/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;

public class InputSplitPathOrganizer {
    private final ZooKeeperExt zooKeeper;
    private final List<String> pathList;
    private final String hostName;

    public InputSplitPathOrganizer(ZooKeeperExt zooKeeper, String zkPathList, String hostName, boolean useLocality) throws KeeperException, InterruptedException {
        this(zooKeeper, zooKeeper.getChildrenExt(zkPathList, false, false, true), hostName, useLocality);
    }

    public InputSplitPathOrganizer(ZooKeeperExt zooKeeper, List<String> inputSplitPathList, String hostName, boolean useLocality) {
        this.zooKeeper = zooKeeper;
        this.pathList = Lists.newArrayList(inputSplitPathList);
        this.hostName = hostName;
        Collections.shuffle(this.pathList);
        if (useLocality) {
            this.prioritizeLocalInputSplits();
        }
    }

    private void prioritizeLocalInputSplits() {
        ArrayList<String> sortedList = new ArrayList<String>();
        Iterator<String> iterator = this.pathList.iterator();
        while (iterator.hasNext()) {
            String hosts;
            String path = iterator.next();
            try {
                hosts = this.getLocationsFromZkInputSplitData(path);
            }
            catch (IOException ioe) {
                hosts = null;
            }
            catch (KeeperException ke) {
                hosts = null;
            }
            catch (InterruptedException ie) {
                hosts = null;
            }
            if (hosts == null || !hosts.contains(this.hostName)) continue;
            sortedList.add(path);
            iterator.remove();
        }
        this.pathList.addAll(0, sortedList);
    }

    private String getLocationsFromZkInputSplitData(String zkSplitPath) throws IOException, KeeperException, InterruptedException {
        byte[] locationData = this.zooKeeper.getData(zkSplitPath, false, null);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(locationData));
        return Text.readString((DataInput)inputStream);
    }

    public Iterable<String> getPathList() {
        return this.pathList;
    }
}

