/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.io.GiraphInputFormat;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.giraph.worker.InputSplitPathOrganizer;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public abstract class FullInputSplitCallable<I extends WritableComparable, V extends Writable, E extends Writable>
implements Callable<Integer> {
    private static final Logger LOG = Logger.getLogger(FullInputSplitCallable.class);
    private static final Time TIME = SystemTime.get();
    protected final ImmutableClassesGiraphConfiguration<I, V, E> configuration;
    protected final Mapper.Context context;
    private final List<String> pathList;
    private final AtomicInteger currentIndex;
    private final ZooKeeperExt zooKeeperExt;
    private final long startNanos = TIME.getNanoseconds();

    public FullInputSplitCallable(InputSplitPathOrganizer splitOrganizer, Mapper.Context context, ImmutableClassesGiraphConfiguration<I, V, E> configuration, ZooKeeperExt zooKeeperExt, AtomicInteger currentIndex) {
        this.pathList = Lists.newArrayList(splitOrganizer.getPathList());
        this.currentIndex = currentIndex;
        this.zooKeeperExt = zooKeeperExt;
        this.context = context;
        this.configuration = configuration;
    }

    public abstract GiraphInputFormat getInputFormat();

    protected abstract Integer readInputSplit(InputSplit var1) throws IOException, InterruptedException;

    @Override
    public Integer call() {
        int entries = 0;
        int inputSplitsProcessed = 0;
        try {
            int pos;
            while ((pos = this.currentIndex.getAndIncrement()) < this.pathList.size()) {
                String inputSplitPath = this.pathList.get(pos);
                entries += this.loadInputSplit(inputSplitPath).intValue();
                this.context.progress();
                ++inputSplitsProcessed;
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("call: InterruptedException", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("call: IOException", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("call: ClassNotFoundException", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("call: InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("call: IllegalAccessException", e);
        }
        if (LOG.isInfoEnabled()) {
            float seconds = (float)Times.getNanosSince(TIME, this.startNanos) / 1.0E9f;
            float entriesPerSecond = (float)entries / seconds;
            LOG.info((Object)("call: Loaded " + inputSplitsProcessed + " " + "input splits in " + seconds + " secs, " + entries + " " + entriesPerSecond + " entries/sec"));
        }
        return entries;
    }

    private Integer loadInputSplit(String inputSplitPath) throws IOException, ClassNotFoundException, InterruptedException, InstantiationException, IllegalAccessException {
        InputSplit inputSplit = this.getInputSplit(inputSplitPath);
        Integer entriesRead = this.readInputSplit(inputSplit);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("loadFromInputSplit: Finished loading " + inputSplitPath + " " + entriesRead));
        }
        return entriesRead;
    }

    protected InputSplit getInputSplit(String inputSplitPath) throws IOException, ClassNotFoundException {
        byte[] splitList;
        try {
            splitList = this.zooKeeperExt.getData(inputSplitPath, false, null);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("getInputSplit: KeeperException on " + inputSplitPath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("getInputSplit: IllegalStateException on " + inputSplitPath, e);
        }
        this.context.progress();
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(splitList));
        InputSplit inputSplit = this.getInputFormat().readInputSplit(inputStream);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getInputSplit: Processing " + inputSplitPath + " from ZooKeeper and got input split '" + inputSplit.toString() + "'"));
        }
        return inputSplit;
    }
}

