/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.VertexEdgeCount;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.filters.EdgeInputFilter;
import org.apache.giraph.utils.LoggerUtils;
import org.apache.giraph.utils.MemoryUtils;
import org.apache.giraph.worker.BspServiceWorker;
import org.apache.giraph.worker.InputSplitsCallable;
import org.apache.giraph.worker.InputSplitsHandler;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.giraph.worker.WorkerThreadGlobalCommUsage;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class EdgeInputSplitsCallable<I extends WritableComparable, V extends Writable, E extends Writable>
extends InputSplitsCallable<I, V, E> {
    public static final int EDGES_UPDATE_PERIOD = 1000000;
    public static final int EDGES_FILTERED_UPDATE_PERIOD = 10000;
    private static final Logger LOG = Logger.getLogger(EdgeInputSplitsCallable.class);
    private final WorkerThreadGlobalCommUsage globalCommUsage;
    private final BspServiceWorker<I, V, E> bspServiceWorker;
    private final EdgeInputFormat<I, E> edgeInputFormat;
    private final long inputSplitMaxEdges;
    private final boolean canEmbedInIds;
    private final EdgeInputFilter<I, E> edgeInputFilter;
    private final Meter totalEdgesMeter;
    private final Counter totalEdgesFiltered;

    public EdgeInputSplitsCallable(EdgeInputFormat<I, E> edgeInputFormat, Mapper.Context context, ImmutableClassesGiraphConfiguration<I, V, E> configuration, BspServiceWorker<I, V, E> bspServiceWorker, InputSplitsHandler splitsHandler, ZooKeeperExt zooKeeperExt) {
        super(context, configuration, bspServiceWorker, splitsHandler, zooKeeperExt);
        this.edgeInputFormat = edgeInputFormat;
        this.bspServiceWorker = bspServiceWorker;
        this.inputSplitMaxEdges = configuration.getInputSplitMaxEdges();
        this.globalCommUsage = bspServiceWorker.getAggregatorHandler().newThreadAggregatorUsage();
        this.edgeInputFilter = configuration.getEdgeInputFilter();
        this.canEmbedInIds = bspServiceWorker.getLocalData().getMappingStoreOps() != null && bspServiceWorker.getLocalData().getMappingStoreOps().hasEmbedding();
        this.totalEdgesMeter = EdgeInputSplitsCallable.getTotalEdgesLoadedMeter();
        this.totalEdgesFiltered = EdgeInputSplitsCallable.getTotalEdgesFilteredCounter();
    }

    @Override
    public EdgeInputFormat<I, E> getInputFormat() {
        return this.edgeInputFormat;
    }

    @Override
    protected VertexEdgeCount readInputSplit(InputSplit inputSplit) throws IOException, InterruptedException {
        EdgeReader<I, E> edgeReader = this.edgeInputFormat.createEdgeReader(inputSplit, (TaskAttemptContext)this.context);
        edgeReader.setConf(this.configuration);
        edgeReader.initialize(inputSplit, (TaskAttemptContext)this.context);
        edgeReader.setWorkerGlobalCommUsage(this.globalCommUsage);
        long inputSplitEdgesLoaded = 0L;
        long inputSplitEdgesFiltered = 0L;
        while (edgeReader.nextEdge()) {
            I sourceId = edgeReader.getCurrentSourceId();
            Edge<I, E> readerEdge = edgeReader.getCurrentEdge();
            if (sourceId == null) {
                throw new IllegalArgumentException("readInputSplit: Edge reader returned an edge without a source vertex id!  - " + readerEdge);
            }
            if (readerEdge.getTargetVertexId() == null) {
                throw new IllegalArgumentException("readInputSplit: Edge reader returned an edge without a target vertex id!  - " + readerEdge);
            }
            if (readerEdge.getValue() == null) {
                throw new IllegalArgumentException("readInputSplit: Edge reader returned an edge without a value!  - " + readerEdge);
            }
            if (this.canEmbedInIds) {
                this.bspServiceWorker.getLocalData().getMappingStoreOps().embedTargetInfo(sourceId);
                this.bspServiceWorker.getLocalData().getMappingStoreOps().embedTargetInfo(readerEdge.getTargetVertexId());
            }
            ++inputSplitEdgesLoaded;
            if (this.edgeInputFilter.dropEdge(sourceId, readerEdge)) {
                if (++inputSplitEdgesFiltered % 10000L != 0L) continue;
                this.totalEdgesFiltered.inc(inputSplitEdgesFiltered);
                inputSplitEdgesFiltered = 0L;
                continue;
            }
            this.workerClientRequestProcessor.sendEdgeRequest(sourceId, readerEdge);
            if (inputSplitEdgesLoaded % 1000000L == 0L) {
                this.totalEdgesMeter.mark(1000000L);
                WorkerProgress.get().addEdgesLoaded(1000000L);
                LoggerUtils.setStatusAndLog((TaskAttemptContext)this.context, LOG, Level.INFO, "readEdgeInputSplit: Loaded " + this.totalEdgesMeter.count() + " edges at " + this.totalEdgesMeter.meanRate() + " edges/sec " + MemoryUtils.getRuntimeMemoryStats());
            }
            if (this.inputSplitMaxEdges <= 0L || inputSplitEdgesLoaded < this.inputSplitMaxEdges) continue;
            if (!LOG.isInfoEnabled()) break;
            LOG.info((Object)("readInputSplit: Leaving the input split early, reached maximum edges " + inputSplitEdgesLoaded));
            break;
        }
        edgeReader.close();
        this.totalEdgesFiltered.inc(inputSplitEdgesFiltered);
        this.totalEdgesMeter.mark(inputSplitEdgesLoaded % 1000000L);
        WorkerProgress.get().addEdgesLoaded(inputSplitEdgesLoaded % 1000000L);
        WorkerProgress.get().incrementEdgeInputSplitsLoaded();
        return new VertexEdgeCount(0L, inputSplitEdgesLoaded);
    }
}

