/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.worker;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.iharder.Base64;
import org.apache.giraph.bsp.ApplicationState;
import org.apache.giraph.bsp.BspService;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.bsp.CheckpointStatus;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.WorkerClient;
import org.apache.giraph.comm.WorkerServer;
import org.apache.giraph.comm.aggregators.WorkerAggregatorRequestProcessor;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.queue.AsyncMessageStoreWrapper;
import org.apache.giraph.comm.netty.NettyWorkerAggregatorRequestProcessor;
import org.apache.giraph.comm.netty.NettyWorkerClient;
import org.apache.giraph.comm.netty.NettyWorkerClientRequestProcessor;
import org.apache.giraph.comm.netty.NettyWorkerServer;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.AddressesAndPartitionsWritable;
import org.apache.giraph.graph.FinishedSuperstepStats;
import org.apache.giraph.graph.GlobalStats;
import org.apache.giraph.graph.GraphTaskManager;
import org.apache.giraph.graph.InputSplitEvents;
import org.apache.giraph.graph.InputSplitPaths;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexEdgeCount;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.EdgeWriter;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.io.internal.WrappedEdgeOutputFormat;
import org.apache.giraph.io.internal.WrappedVertexOutputFormat;
import org.apache.giraph.io.superstep_output.SuperstepOutput;
import org.apache.giraph.mapping.translate.TranslateEdge;
import org.apache.giraph.master.MasterInfo;
import org.apache.giraph.master.SuperstepClasses;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.GiraphTimer;
import org.apache.giraph.metrics.GiraphTimerContext;
import org.apache.giraph.metrics.ResetSuperstepMetricsObserver;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.giraph.metrics.WorkerSuperstepMetrics;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionExchange;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.partition.WorkerGraphPartitioner;
import org.apache.giraph.utils.CallableFactory;
import org.apache.giraph.utils.JMapHistoDumper;
import org.apache.giraph.utils.LoggerUtils;
import org.apache.giraph.utils.MemoryUtils;
import org.apache.giraph.utils.ProgressableUtils;
import org.apache.giraph.utils.ReactiveJMapHistoDumper;
import org.apache.giraph.utils.WritableUtils;
import org.apache.giraph.worker.EdgeInputSplitsCallableFactory;
import org.apache.giraph.worker.InputSplitPathOrganizer;
import org.apache.giraph.worker.InputSplitsHandler;
import org.apache.giraph.worker.LocalData;
import org.apache.giraph.worker.MappingInputSplitsCallableFactory;
import org.apache.giraph.worker.VertexInputSplitsCallableFactory;
import org.apache.giraph.worker.WorkerAggregatorHandler;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.giraph.worker.WorkerObserver;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.giraph.worker.WorkerProgressWriter;
import org.apache.giraph.zk.BspEvent;
import org.apache.giraph.zk.PredicateLock;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BspServiceWorker<I extends WritableComparable, V extends Writable, E extends Writable>
extends BspService<I, V, E>
implements CentralizedServiceWorker<I, V, E>,
ResetSuperstepMetricsObserver {
    public static final String TIMER_WAIT_REQUESTS = "wait-requests-us";
    private static final Logger LOG = Logger.getLogger(BspServiceWorker.class);
    private String myHealthZnode;
    private final WorkerInfo workerInfo;
    private final WorkerGraphPartitioner<I, V, E> workerGraphPartitioner;
    private final LocalData<I, V, E, ? extends Writable> localData;
    private final TranslateEdge<I, E> translateEdge;
    private final WorkerClient<I, V, E> workerClient;
    private final WorkerServer<I, V, E> workerServer;
    private final WorkerAggregatorRequestProcessor workerAggregatorRequestProcessor;
    private MasterInfo masterInfo = new MasterInfo();
    private List<WorkerInfo> workerInfoList = Lists.newArrayList();
    private final BspEvent partitionExchangeChildrenChanged;
    private final WorkerContext workerContext;
    private final WorkerAggregatorHandler globalCommHandler;
    private final SuperstepOutput<I, V, E> superstepOutput;
    private final WorkerObserver[] observers;
    private final WorkerProgressWriter workerProgressWriter;
    private GiraphTimer wcPostSuperstepTimer;
    private GiraphTimer waitRequestsTimer;

    public BspServiceWorker(Mapper.Context context, GraphTaskManager<I, V, E> graphTaskManager) throws IOException, InterruptedException {
        super(context, graphTaskManager);
        ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        this.localData = new LocalData(conf);
        this.translateEdge = this.getConfiguration().edgeTranslationInstance();
        if (this.translateEdge != null) {
            this.translateEdge.initialize(this);
        }
        this.partitionExchangeChildrenChanged = new PredicateLock((Progressable)context);
        this.registerBspEvent(this.partitionExchangeChildrenChanged);
        this.workerGraphPartitioner = this.getGraphPartitionerFactory().createWorkerGraphPartitioner();
        this.workerInfo = new WorkerInfo();
        this.workerServer = new NettyWorkerServer(conf, this, context, graphTaskManager.createUncaughtExceptionHandler());
        this.workerInfo.setInetSocketAddress(this.workerServer.getMyAddress());
        this.workerInfo.setTaskId(this.getTaskPartition());
        this.workerClient = new NettyWorkerClient(context, conf, this, graphTaskManager.createUncaughtExceptionHandler());
        this.workerAggregatorRequestProcessor = new NettyWorkerAggregatorRequestProcessor((Progressable)this.getContext(), conf, this);
        this.globalCommHandler = new WorkerAggregatorHandler(this, conf, (Progressable)context);
        this.workerContext = conf.createWorkerContext();
        this.workerContext.setWorkerGlobalCommUsage(this.globalCommHandler);
        this.superstepOutput = conf.createSuperstepOutput(context);
        if (conf.isJMapHistogramDumpEnabled()) {
            conf.addWorkerObserverClass(JMapHistoDumper.class);
        }
        if (conf.isReactiveJmapHistogramDumpEnabled()) {
            conf.addWorkerObserverClass(ReactiveJMapHistoDumper.class);
        }
        this.observers = conf.createWorkerObservers();
        WorkerProgress.get().setTaskId(this.getTaskPartition());
        this.workerProgressWriter = conf.trackJobProgressOnClient() ? new WorkerProgressWriter(graphTaskManager.getJobProgressTracker()) : null;
        GiraphMetrics.get().addSuperstepResetObserver(this);
    }

    @Override
    public void newSuperstep(SuperstepMetricsRegistry superstepMetrics) {
        this.waitRequestsTimer = new GiraphTimer(superstepMetrics, TIMER_WAIT_REQUESTS, TimeUnit.MICROSECONDS);
        this.wcPostSuperstepTimer = new GiraphTimer(superstepMetrics, "worker-context-post-superstep", TimeUnit.MICROSECONDS);
    }

    @Override
    public WorkerContext getWorkerContext() {
        return this.workerContext;
    }

    @Override
    public WorkerObserver[] getWorkerObservers() {
        return this.observers;
    }

    @Override
    public WorkerClient<I, V, E> getWorkerClient() {
        return this.workerClient;
    }

    public LocalData<I, V, E, ? extends Writable> getLocalData() {
        return this.localData;
    }

    public TranslateEdge<I, E> getTranslateEdge() {
        return this.translateEdge;
    }

    public boolean isHealthy() {
        return true;
    }

    private VertexEdgeCount loadInputSplits(List<String> inputSplitPathList, CallableFactory<VertexEdgeCount> inputSplitsCallableFactory) throws KeeperException, InterruptedException {
        VertexEdgeCount vertexEdgeCount = new VertexEdgeCount();
        int maxInputSplitThreads = (inputSplitPathList.size() - 1) / this.getConfiguration().getMaxWorkers() + 1;
        int numThreads = Math.min(this.getConfiguration().getNumInputSplitsThreads(), maxInputSplitThreads);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("loadInputSplits: Using " + numThreads + " thread(s), " + "originally " + this.getConfiguration().getNumInputSplitsThreads() + " threads(s) for " + inputSplitPathList.size() + " total splits."));
        }
        List<VertexEdgeCount> results = ProgressableUtils.getResultsWithNCallables(inputSplitsCallableFactory, numThreads, "load-%d", (Progressable)this.getContext());
        for (VertexEdgeCount result : results) {
            vertexEdgeCount = vertexEdgeCount.incrVertexEdgeCount(result);
        }
        this.workerClient.waitAllRequests();
        return vertexEdgeCount;
    }

    private long loadMapping() throws KeeperException, InterruptedException {
        List<String> inputSplitPathList = this.getZkExt().getChildrenExt(this.mappingInputSplitsPaths.getPath(), false, false, true);
        InputSplitPathOrganizer splitOrganizer = new InputSplitPathOrganizer(this.getZkExt(), inputSplitPathList, this.getWorkerInfo().getHostname(), this.getConfiguration().useInputSplitLocality());
        MappingInputSplitsCallableFactory mappingInputSplitsCallableFactory = new MappingInputSplitsCallableFactory(this.getConfiguration().createWrappedMappingInputFormat(), splitOrganizer, this.getContext(), this.getConfiguration(), this, this.getZkExt());
        long entriesLoaded = 0L;
        int maxInputSplitThreads = inputSplitPathList.size();
        int numThreads = Math.min(this.getConfiguration().getNumInputSplitsThreads(), maxInputSplitThreads);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("loadInputSplits: Using " + numThreads + " thread(s), " + "originally " + this.getConfiguration().getNumInputSplitsThreads() + " threads(s) for " + inputSplitPathList.size() + " total splits."));
        }
        List<Integer> results = ProgressableUtils.getResultsWithNCallables(mappingInputSplitsCallableFactory, numThreads, "load-mapping-%d", (Progressable)this.getContext());
        for (Integer result : results) {
            entriesLoaded += (long)result.intValue();
        }
        this.localData.getMappingStore().postFilling();
        return entriesLoaded;
    }

    private VertexEdgeCount loadVertices() throws KeeperException, InterruptedException {
        List<String> inputSplitPathList = this.getZkExt().getChildrenExt(this.vertexInputSplitsPaths.getPath(), false, false, true);
        InputSplitPathOrganizer splitOrganizer = new InputSplitPathOrganizer(this.getZkExt(), inputSplitPathList, this.getWorkerInfo().getHostname(), this.getConfiguration().useInputSplitLocality());
        InputSplitsHandler splitsHandler = new InputSplitsHandler(splitOrganizer, this.getZkExt(), this.getContext(), "/_vertexInputSplitReserved", "/_vertexInputSplitFinished");
        VertexInputSplitsCallableFactory inputSplitsCallableFactory = new VertexInputSplitsCallableFactory(this.getConfiguration().createWrappedVertexInputFormat(), this.getContext(), this.getConfiguration(), this, splitsHandler, this.getZkExt());
        return this.loadInputSplits(inputSplitPathList, inputSplitsCallableFactory);
    }

    private long loadEdges() throws KeeperException, InterruptedException {
        List<String> inputSplitPathList = this.getZkExt().getChildrenExt(this.edgeInputSplitsPaths.getPath(), false, false, true);
        InputSplitPathOrganizer splitOrganizer = new InputSplitPathOrganizer(this.getZkExt(), inputSplitPathList, this.getWorkerInfo().getHostname(), this.getConfiguration().useInputSplitLocality());
        InputSplitsHandler splitsHandler = new InputSplitsHandler(splitOrganizer, this.getZkExt(), this.getContext(), "/_edgeInputSplitReserved", "/_edgeInputSplitFinished");
        EdgeInputSplitsCallableFactory inputSplitsCallableFactory = new EdgeInputSplitsCallableFactory(this.getConfiguration().createWrappedEdgeInputFormat(), this.getContext(), this.getConfiguration(), this, splitsHandler, this.getZkExt());
        return this.loadInputSplits(inputSplitPathList, inputSplitsCallableFactory).getEdgeCount();
    }

    @Override
    public MasterInfo getMasterInfo() {
        return this.masterInfo;
    }

    @Override
    public List<WorkerInfo> getWorkerInfoList() {
        return this.workerInfoList;
    }

    private void ensureInputSplitsReady(InputSplitPaths inputSplitPaths, InputSplitEvents inputSplitEvents) {
        while (true) {
            Stat inputSplitsReadyStat;
            try {
                inputSplitsReadyStat = this.getZkExt().exists(inputSplitPaths.getAllReadyPath(), true);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("ensureInputSplitsReady: KeeperException waiting on input splits", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("ensureInputSplitsReady: InterruptedException waiting on input splits", e);
            }
            if (inputSplitsReadyStat != null) break;
            inputSplitEvents.getAllReadyChanged().waitForever();
            inputSplitEvents.getAllReadyChanged().reset();
        }
    }

    private void markCurrentWorkerDoneThenWaitForOthers(InputSplitPaths inputSplitPaths, InputSplitEvents inputSplitEvents) {
        String workerInputSplitsDonePath = inputSplitPaths.getDonePath() + "/" + this.getWorkerInfo().getHostnameId();
        try {
            this.getZkExt().createExt(workerInputSplitsDonePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("markCurrentWorkerDoneThenWaitForOthers: KeeperException creating worker done splits", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("markCurrentWorkerDoneThenWaitForOthers: InterruptedException creating worker done splits", e);
        }
        while (true) {
            Stat inputSplitsDoneStat;
            try {
                inputSplitsDoneStat = this.getZkExt().exists(inputSplitPaths.getAllDonePath(), true);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("markCurrentWorkerDoneThenWaitForOthers: KeeperException waiting on worker done splits", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("markCurrentWorkerDoneThenWaitForOthers: InterruptedException waiting on worker done splits", e);
            }
            if (inputSplitsDoneStat != null) break;
            inputSplitEvents.getAllDoneChanged().waitForever();
            inputSplitEvents.getAllDoneChanged().reset();
        }
    }

    @Override
    public FinishedSuperstepStats setup() {
        VertexEdgeCount vertexEdgeCount;
        if (this.getRestartedSuperstep() != Long.MIN_VALUE) {
            this.setCachedSuperstep(this.getRestartedSuperstep());
            return new FinishedSuperstepStats(0L, false, 0L, 0L, true, CheckpointStatus.NONE);
        }
        JSONObject jobState = this.getJobState();
        if (jobState != null) {
            try {
                if (ApplicationState.valueOf(jobState.getString("_stateKey")) == ApplicationState.START_SUPERSTEP && jobState.getLong("_superstepKey") == this.getSuperstep()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("setup: Restarting from an automated checkpointed superstep " + this.getSuperstep() + ", attempt " + this.getApplicationAttempt()));
                    }
                    this.setRestartedSuperstep(this.getSuperstep());
                    return new FinishedSuperstepStats(0L, false, 0L, 0L, true, CheckpointStatus.NONE);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException("setup: Failed to get key-values from " + jobState.toString(), e);
            }
        }
        Collection<PartitionOwner> masterSetPartitionOwners = this.startSuperstep();
        this.workerGraphPartitioner.updatePartitionOwners(this.getWorkerInfo(), masterSetPartitionOwners);
        this.workerClient.setup(this.getConfiguration().authenticate());
        this.globalCommHandler.prepareSuperstep(this.workerAggregatorRequestProcessor);
        if (this.getConfiguration().hasMappingInputFormat()) {
            long entriesLoaded;
            this.ensureInputSplitsReady(this.mappingInputSplitsPaths, this.mappingInputSplitsEvents);
            this.getContext().progress();
            try {
                entriesLoaded = this.loadMapping();
                this.getGraphPartitionerFactory().initialize(this.localData);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("setup: loadMapping failed with InterruptedException", e);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("setup: loadMapping failed with KeeperException", e);
            }
            this.getContext().progress();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("setup: Finally loaded a total of " + entriesLoaded + " entries from inputSplits"));
            }
            this.markCurrentWorkerDoneThenWaitForOthers(this.mappingInputSplitsPaths, this.mappingInputSplitsEvents);
            this.localData.printStats();
        }
        if (this.getConfiguration().hasVertexInputFormat()) {
            this.ensureInputSplitsReady(this.vertexInputSplitsPaths, this.vertexInputSplitsEvents);
            this.getContext().progress();
            try {
                vertexEdgeCount = this.loadVertices();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("setup: loadVertices failed with InterruptedException", e);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("setup: loadVertices failed with KeeperException", e);
            }
            this.getContext().progress();
        } else {
            vertexEdgeCount = new VertexEdgeCount();
        }
        WorkerProgress.get().finishLoadingVertices();
        if (this.getConfiguration().hasEdgeInputFormat()) {
            this.ensureInputSplitsReady(this.edgeInputSplitsPaths, this.edgeInputSplitsEvents);
            this.getContext().progress();
            try {
                vertexEdgeCount = vertexEdgeCount.incrVertexEdgeCount(0L, this.loadEdges());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("setup: loadEdges failed with InterruptedException", e);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("setup: loadEdges failed with KeeperException", e);
            }
            this.getContext().progress();
        }
        WorkerProgress.get().finishLoadingEdges();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("setup: Finally loaded a total of " + vertexEdgeCount));
        }
        if (this.getConfiguration().hasVertexInputFormat()) {
            this.markCurrentWorkerDoneThenWaitForOthers(this.vertexInputSplitsPaths, this.vertexInputSplitsEvents);
        }
        if (this.getConfiguration().hasEdgeInputFormat()) {
            this.markCurrentWorkerDoneThenWaitForOthers(this.edgeInputSplitsPaths, this.edgeInputSplitsEvents);
        }
        for (PartitionOwner partitionOwner : masterSetPartitionOwners) {
            if (!partitionOwner.getWorkerInfo().equals(this.getWorkerInfo()) || this.getPartitionStore().hasPartition(partitionOwner.getPartitionId())) continue;
            Partition partition = this.getConfiguration().createPartition(partitionOwner.getPartitionId(), (Progressable)this.getContext());
            this.getPartitionStore().addPartition(partition);
        }
        this.localData.removeMappingStoreIfPossible();
        if (this.getConfiguration().hasEdgeInputFormat()) {
            this.getServerData().getEdgeStore().moveEdgesToVertices();
        }
        ArrayList<PartitionStats> partitionStatsList = new ArrayList<PartitionStats>();
        for (Integer partitionId : this.getPartitionStore().getPartitionIds()) {
            Partition<I, V, E> partition = this.getPartitionStore().getOrCreatePartition(partitionId);
            PartitionStats partitionStats = new PartitionStats(partition.getId(), partition.getVertexCount(), 0L, partition.getEdgeCount(), 0L, 0L);
            partitionStatsList.add(partitionStats);
            this.getPartitionStore().putPartition(partition);
        }
        this.workerGraphPartitioner.finalizePartitionStats(partitionStatsList, this.getPartitionStore());
        return this.finishSuperstep(partitionStatsList, null);
    }

    private void registerHealth(long superstep) {
        JSONArray hostnamePort = new JSONArray();
        hostnamePort.put((Object)this.getHostname());
        hostnamePort.put(this.workerInfo.getPort());
        String myHealthPath = null;
        myHealthPath = this.isHealthy() ? this.getWorkerInfoHealthyPath(this.getApplicationAttempt(), this.getSuperstep()) : this.getWorkerInfoUnhealthyPath(this.getApplicationAttempt(), this.getSuperstep());
        myHealthPath = myHealthPath + "/" + this.workerInfo.getHostnameId();
        try {
            this.myHealthZnode = this.getZkExt().createExt(myHealthPath, WritableUtils.writeToByteArray(this.workerInfo), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, true);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn((Object)("registerHealth: myHealthPath already exists (likely from previous failure): " + myHealthPath + ".  Waiting for change in attempts " + "to re-join the application"));
            this.getApplicationAttemptChangedEvent().waitForever();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"registerHealth: Got application attempt changed event, killing self");
            }
            throw new IllegalStateException("registerHealth: Trying to get the new application attempt by killing self", e);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("Creating " + myHealthPath + " failed with KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Creating " + myHealthPath + " failed with InterruptedException", e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("registerHealth: Created my health node for attempt=" + this.getApplicationAttempt() + ", superstep=" + this.getSuperstep() + " with " + this.myHealthZnode + " and workerInfo= " + this.workerInfo));
        }
    }

    private void unregisterHealth() {
        LOG.error((Object)("unregisterHealth: Got failure, unregistering health on " + this.myHealthZnode + " on superstep " + this.getSuperstep()));
        try {
            this.getZkExt().deleteExt(this.myHealthZnode, -1, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unregisterHealth: InterruptedException - Couldn't delete " + this.myHealthZnode, e);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("unregisterHealth: KeeperException - Couldn't delete " + this.myHealthZnode, e);
        }
    }

    @Override
    public void failureCleanup() {
        this.unregisterHealth();
    }

    @Override
    public Collection<? extends PartitionOwner> startSuperstep() {
        if (this.getSuperstep() != -1L) {
            this.workerServer.prepareSuperstep();
        }
        this.registerHealth(this.getSuperstep());
        String addressesAndPartitionsPath = this.getAddressesAndPartitionsPath(this.getApplicationAttempt(), this.getSuperstep());
        AddressesAndPartitionsWritable addressesAndPartitions = new AddressesAndPartitionsWritable(this.workerGraphPartitioner.createPartitionOwner().getClass());
        try {
            while (this.getZkExt().exists(addressesAndPartitionsPath, true) == null) {
                this.getAddressesAndPartitionsReadyChangedEvent().waitForever();
                this.getAddressesAndPartitionsReadyChangedEvent().reset();
            }
            WritableUtils.readFieldsFromZnode(this.getZkExt(), addressesAndPartitionsPath, false, null, addressesAndPartitions);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("startSuperstep: KeeperException getting assignments", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("startSuperstep: InterruptedException getting assignments", e);
        }
        this.workerInfoList.clear();
        this.workerInfoList = addressesAndPartitions.getWorkerInfos();
        this.masterInfo = addressesAndPartitions.getMasterInfo();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("startSuperstep: " + this.masterInfo));
            LOG.info((Object)("startSuperstep: Ready for computation on superstep " + this.getSuperstep() + " since worker " + "selection and vertex range assignments are done in " + addressesAndPartitionsPath));
        }
        this.getContext().setStatus("startSuperstep: " + this.getGraphTaskManager().getGraphFunctions().toString() + " - Attempt=" + this.getApplicationAttempt() + ", Superstep=" + this.getSuperstep());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("startSuperstep: addressesAndPartitions" + addressesAndPartitions.getWorkerInfos()));
            for (PartitionOwner partitionOwner : addressesAndPartitions.getPartitionOwners()) {
                LOG.debug((Object)(partitionOwner.getPartitionId() + " " + partitionOwner.getWorkerInfo()));
            }
        }
        return addressesAndPartitions.getPartitionOwners();
    }

    @Override
    public FinishedSuperstepStats finishSuperstep(List<PartitionStats> partitionStatsList, GiraphTimerContext superstepTimerContext) {
        this.waitForRequestsToFinish();
        this.getGraphTaskManager().notifyFinishedCommunication();
        long workerSentMessages = 0L;
        long workerSentMessageBytes = 0L;
        long localVertices = 0L;
        for (PartitionStats partitionStats : partitionStatsList) {
            workerSentMessages += partitionStats.getMessagesSentCount();
            workerSentMessageBytes += partitionStats.getMessageBytesSentCount();
            localVertices += partitionStats.getVertexCount();
        }
        if (this.getSuperstep() != -1L) {
            this.postSuperstepCallbacks();
        }
        this.globalCommHandler.finishSuperstep(this.workerAggregatorRequestProcessor);
        MessageStore incomingMessageStore = this.getServerData().getIncomingMessageStore();
        if (incomingMessageStore instanceof AsyncMessageStoreWrapper) {
            ((AsyncMessageStoreWrapper)incomingMessageStore).waitToComplete();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("finishSuperstep: Superstep " + this.getSuperstep() + ", messages = " + workerSentMessages + " " + ", message bytes = " + workerSentMessageBytes + " , " + MemoryUtils.getRuntimeMemoryStats()));
        }
        if (superstepTimerContext != null) {
            superstepTimerContext.stop();
        }
        this.writeFinshedSuperstepInfoToZK(partitionStatsList, workerSentMessages, workerSentMessageBytes);
        LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "finishSuperstep: (waiting for rest of workers) " + this.getGraphTaskManager().getGraphFunctions().toString() + " - Attempt=" + this.getApplicationAttempt() + ", Superstep=" + this.getSuperstep());
        String superstepFinishedNode = this.getSuperstepFinishedPath(this.getApplicationAttempt(), this.getSuperstep());
        this.waitForOtherWorkers(superstepFinishedNode);
        GlobalStats globalStats = new GlobalStats();
        SuperstepClasses superstepClasses = new SuperstepClasses();
        WritableUtils.readFieldsFromZnode(this.getZkExt(), superstepFinishedNode, false, null, globalStats, superstepClasses);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("finishSuperstep: Completed superstep " + this.getSuperstep() + " with global stats " + globalStats + " and classes " + superstepClasses));
        }
        this.getContext().setStatus("finishSuperstep: (all workers done) " + this.getGraphTaskManager().getGraphFunctions().toString() + " - Attempt=" + this.getApplicationAttempt() + ", Superstep=" + this.getSuperstep());
        this.incrCachedSuperstep();
        this.getConfiguration().updateSuperstepClasses(superstepClasses);
        return new FinishedSuperstepStats(localVertices, globalStats.getHaltComputation(), globalStats.getVertexCount(), globalStats.getEdgeCount(), false, globalStats.getCheckpointStatus());
    }

    private void postSuperstepCallbacks() {
        GiraphTimerContext timerContext = this.wcPostSuperstepTimer.time();
        this.getWorkerContext().postSuperstep();
        timerContext.stop();
        this.getContext().progress();
        for (WorkerObserver obs : this.getWorkerObservers()) {
            obs.postSuperstep(this.getSuperstep());
            this.getContext().progress();
        }
    }

    private void waitForRequestsToFinish() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("finishSuperstep: Waiting on all requests, superstep " + this.getSuperstep() + " " + MemoryUtils.getRuntimeMemoryStats()));
        }
        GiraphTimerContext timerContext = this.waitRequestsTimer.time();
        this.workerClient.waitAllRequests();
        timerContext.stop();
    }

    private void waitForOtherWorkers(String superstepFinishedNode) {
        try {
            while (this.getZkExt().exists(superstepFinishedNode, true) == null) {
                this.getSuperstepFinishedEvent().waitForever();
                this.getSuperstepFinishedEvent().reset();
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("finishSuperstep: Failed while waiting for master to signal completion of superstep " + this.getSuperstep(), e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("finishSuperstep: Failed while waiting for master to signal completion of superstep " + this.getSuperstep(), e);
        }
    }

    private void writeFinshedSuperstepInfoToZK(List<PartitionStats> partitionStatsList, long workerSentMessages, long workerSentMessageBytes) {
        Collection<PartitionStats> finalizedPartitionStats = this.workerGraphPartitioner.finalizePartitionStats(partitionStatsList, this.getPartitionStore());
        ArrayList<PartitionStats> finalizedPartitionStatsList = new ArrayList<PartitionStats>(finalizedPartitionStats);
        byte[] partitionStatsBytes = WritableUtils.writeListToByteArray(finalizedPartitionStatsList);
        WorkerSuperstepMetrics metrics = new WorkerSuperstepMetrics();
        metrics.readFromRegistry();
        byte[] metricsBytes = WritableUtils.writeToByteArray(metrics);
        JSONObject workerFinishedInfoObj = new JSONObject();
        try {
            workerFinishedInfoObj.put("_partitionStatsKey", (Object)Base64.encodeBytes((byte[])partitionStatsBytes));
            workerFinishedInfoObj.put("_numMsgsKey", workerSentMessages);
            workerFinishedInfoObj.put("_numMsgBytesKey", workerSentMessageBytes);
            workerFinishedInfoObj.put("_metricsKey", (Object)Base64.encodeBytes((byte[])metricsBytes));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        String finishedWorkerPath = this.getWorkerFinishedPath(this.getApplicationAttempt(), this.getSuperstep()) + "/" + this.getHostnamePartitionId();
        try {
            this.getZkExt().createExt(finishedWorkerPath, workerFinishedInfoObj.toString().getBytes(Charset.defaultCharset()), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn((Object)("finishSuperstep: finished worker path " + finishedWorkerPath + " already exists!"));
        }
        catch (KeeperException e) {
            throw new IllegalStateException("Creating " + finishedWorkerPath + " failed with KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Creating " + finishedWorkerPath + " failed with InterruptedException", e);
        }
    }

    private void saveVertices(long numLocalVertices) throws IOException, InterruptedException {
        ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        if (conf.getVertexOutputFormatClass() == null) {
            LOG.warn((Object)("saveVertices: " + GiraphConstants.VERTEX_OUTPUT_FORMAT_CLASS + " not specified -- there will be no saved output"));
            return;
        }
        if (conf.doOutputDuringComputation()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"saveVertices: The option for doing output during computation is selected, so there will be no saving of the output in the end of application");
            }
            return;
        }
        int numPartitions = this.getPartitionStore().getNumPartitions();
        int numThreads = Math.min(this.getConfiguration().getNumOutputThreads(), numPartitions);
        LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "saveVertices: Starting to save " + numLocalVertices + " vertices " + "using " + numThreads + " threads");
        final WrappedVertexOutputFormat vertexOutputFormat = this.getConfiguration().createWrappedVertexOutputFormat();
        final Queue partitionIdQueue = (Queue)((Object)(numPartitions == 0 ? new LinkedList() : new ArrayBlockingQueue(numPartitions)));
        Iterables.addAll((Collection)partitionIdQueue, this.getPartitionStore().getPartitionIds());
        long verticesToStore = 0L;
        PartitionStore<I, V, E> partitionStore = this.getPartitionStore();
        for (int partitionId : partitionStore.getPartitionIds()) {
            Partition<I, V, E> partition = partitionStore.getOrCreatePartition(partitionId);
            verticesToStore += partition.getVertexCount();
            partitionStore.putPartition(partition);
        }
        WorkerProgress.get().startStoring(verticesToStore, this.getPartitionStore().getNumPartitions());
        CallableFactory<Void> callableFactory = new CallableFactory<Void>(){

            @Override
            public Callable<Void> newCallable(int callableId) {
                return new Callable<Void>(){
                    private static final long VERTICES_TO_UPDATE_PROGRESS = 100000L;

                    @Override
                    public Void call() throws Exception {
                        Integer partitionId;
                        VertexWriter vertexWriter = vertexOutputFormat.createVertexWriter((TaskAttemptContext)BspServiceWorker.this.getContext());
                        vertexWriter.setConf(BspServiceWorker.this.getConfiguration());
                        vertexWriter.initialize((TaskAttemptContext)BspServiceWorker.this.getContext());
                        long nextPrintVertices = 0L;
                        long nextUpdateProgressVertices = 100000L;
                        long nextPrintMsecs = System.currentTimeMillis() + 15000L;
                        int partitionIndex = 0;
                        int numPartitions = BspServiceWorker.this.getPartitionStore().getNumPartitions();
                        while (!partitionIdQueue.isEmpty() && (partitionId = (Integer)partitionIdQueue.poll()) != null) {
                            Partition partition = BspServiceWorker.this.getPartitionStore().getOrCreatePartition(partitionId);
                            long verticesWritten = 0L;
                            for (Vertex vertex : partition) {
                                vertexWriter.writeVertex(vertex);
                                if (++verticesWritten > nextPrintVertices && System.currentTimeMillis() > nextPrintMsecs) {
                                    LoggerUtils.setStatusAndLog((TaskAttemptContext)BspServiceWorker.this.getContext(), LOG, Level.INFO, "saveVertices: Saved " + verticesWritten + " out of " + partition.getVertexCount() + " partition vertices, " + "on partition " + partitionIndex + " out of " + numPartitions);
                                    nextPrintMsecs = System.currentTimeMillis() + 15000L;
                                    nextPrintVertices = verticesWritten + 250000L;
                                }
                                if (verticesWritten < nextUpdateProgressVertices) continue;
                                WorkerProgress.get().addVerticesStored(100000L);
                                nextUpdateProgressVertices += 100000L;
                            }
                            BspServiceWorker.this.getPartitionStore().putPartition(partition);
                            ++partitionIndex;
                            WorkerProgress.get().addVerticesStored(verticesWritten % 100000L);
                            WorkerProgress.get().incrementPartitionsStored();
                        }
                        vertexWriter.close((TaskAttemptContext)BspServiceWorker.this.getContext());
                        return null;
                    }
                };
            }
        };
        ProgressableUtils.getResultsWithNCallables(callableFactory, numThreads, "save-vertices-%d", (Progressable)this.getContext());
        LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "saveVertices: Done saving vertices.");
        if (this.getConfiguration().isPureYarnJob() && this.getConfiguration().getVertexOutputFormatClass() != null) {
            try {
                OutputCommitter outputCommitter = ((VertexOutputFormat)vertexOutputFormat).getOutputCommitter((TaskAttemptContext)this.getContext());
                if (outputCommitter.needsTaskCommit((TaskAttemptContext)this.getContext())) {
                    LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "OutputCommitter: committing task output.");
                    outputCommitter.commitTask((TaskAttemptContext)this.getContext());
                }
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"Interrupted while attempting to obtain OutputCommitter.", (Throwable)ie);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Master task's attempt to commit output has FAILED.", (Throwable)ioe);
            }
        }
    }

    private void saveEdges() throws IOException, InterruptedException {
        final ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        if (conf.getEdgeOutputFormatClass() == null) {
            LOG.warn((Object)("saveEdges: " + GiraphConstants.EDGE_OUTPUT_FORMAT_CLASS + "Make sure that the EdgeOutputFormat is not required."));
            return;
        }
        int numPartitions = this.getPartitionStore().getNumPartitions();
        int numThreads = Math.min(conf.getNumOutputThreads(), numPartitions);
        LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "saveEdges: Starting to save the edges using " + numThreads + " threads");
        final WrappedEdgeOutputFormat edgeOutputFormat = conf.createWrappedEdgeOutputFormat();
        final Queue partitionIdQueue = (Queue)((Object)(numPartitions == 0 ? new LinkedList() : new ArrayBlockingQueue(numPartitions)));
        Iterables.addAll((Collection)partitionIdQueue, this.getPartitionStore().getPartitionIds());
        CallableFactory<Void> callableFactory = new CallableFactory<Void>(){

            @Override
            public Callable<Void> newCallable(int callableId) {
                return new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Integer partitionId;
                        EdgeWriter edgeWriter = edgeOutputFormat.createEdgeWriter((TaskAttemptContext)BspServiceWorker.this.getContext());
                        edgeWriter.setConf(conf);
                        edgeWriter.initialize((TaskAttemptContext)BspServiceWorker.this.getContext());
                        long nextPrintVertices = 0L;
                        long nextPrintMsecs = System.currentTimeMillis() + 15000L;
                        int partitionIndex = 0;
                        int numPartitions = BspServiceWorker.this.getPartitionStore().getNumPartitions();
                        while (!partitionIdQueue.isEmpty() && (partitionId = (Integer)partitionIdQueue.poll()) != null) {
                            Partition partition = BspServiceWorker.this.getPartitionStore().getOrCreatePartition(partitionId);
                            long vertices = 0L;
                            long edges = 0L;
                            long partitionEdgeCount = partition.getEdgeCount();
                            for (Vertex vertex : partition) {
                                for (Edge edge : vertex.getEdges()) {
                                    edgeWriter.writeEdge(vertex.getId(), vertex.getValue(), edge);
                                    ++edges;
                                }
                                if (++vertices <= nextPrintVertices || System.currentTimeMillis() <= nextPrintMsecs) continue;
                                LoggerUtils.setStatusAndLog((TaskAttemptContext)BspServiceWorker.this.getContext(), LOG, Level.INFO, "saveEdges: Saved " + edges + " edges out of " + partitionEdgeCount + " partition edges, on partition " + partitionIndex + " out of " + numPartitions);
                                nextPrintMsecs = System.currentTimeMillis() + 15000L;
                                nextPrintVertices = vertices + 250000L;
                            }
                            BspServiceWorker.this.getPartitionStore().putPartition(partition);
                            ++partitionIndex;
                        }
                        edgeWriter.close((TaskAttemptContext)BspServiceWorker.this.getContext());
                        return null;
                    }
                };
            }
        };
        ProgressableUtils.getResultsWithNCallables(callableFactory, numThreads, "save-vertices-%d", (Progressable)this.getContext());
        LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "saveEdges: Done saving edges.");
        if (conf.isPureYarnJob() && conf.getVertexOutputFormatClass() != null) {
            try {
                OutputCommitter outputCommitter = ((EdgeOutputFormat)edgeOutputFormat).getOutputCommitter((TaskAttemptContext)this.getContext());
                if (outputCommitter.needsTaskCommit((TaskAttemptContext)this.getContext())) {
                    LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "OutputCommitter: committing task output.");
                    outputCommitter.commitTask((TaskAttemptContext)this.getContext());
                }
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"Interrupted while attempting to obtain OutputCommitter.", (Throwable)ie);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Master task's attempt to commit output has FAILED.", (Throwable)ioe);
            }
        }
    }

    @Override
    public void cleanup(FinishedSuperstepStats finishedSuperstepStats) throws IOException, InterruptedException {
        this.workerClient.closeConnections();
        this.setCachedSuperstep(this.getSuperstep() - 1L);
        if (finishedSuperstepStats.getCheckpointStatus() != CheckpointStatus.CHECKPOINT_AND_HALT) {
            this.saveVertices(finishedSuperstepStats.getLocalVertexCount());
            this.saveEdges();
        }
        WorkerProgress.get().finishStoring();
        if (this.workerProgressWriter != null) {
            this.workerProgressWriter.stop();
        }
        this.getPartitionStore().shutdown();
        String workerCleanedUpPath = this.cleanedUpPath + "/" + this.getTaskPartition() + "_worker";
        try {
            String finalFinishedPath = this.getZkExt().createExt(workerCleanedUpPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("cleanup: Notifying master its okay to cleanup with " + finalFinishedPath));
            }
        }
        catch (KeeperException.NodeExistsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("cleanup: Couldn't create finished node '" + workerCleanedUpPath));
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"cleanup: Got KeeperException on notification to master about cleanup", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"cleanup: Got InterruptedException on notification to master about cleanup", (Throwable)e);
        }
        try {
            this.getZkExt().close();
        }
        catch (InterruptedException e) {
            LOG.error((Object)("cleanup: Zookeeper failed to close with " + e));
        }
        if (this.getConfiguration().metricsEnabled()) {
            GiraphMetrics.get().dumpToStream(System.err);
        }
        this.workerServer.close();
    }

    @Override
    public void storeCheckpoint() throws IOException {
        LoggerUtils.setStatusAndLog((TaskAttemptContext)this.getContext(), LOG, Level.INFO, "storeCheckpoint: Starting checkpoint " + this.getGraphTaskManager().getGraphFunctions().toString() + " - Attempt=" + this.getApplicationAttempt() + ", Superstep=" + this.getSuperstep());
        Path metadataFilePath = this.createCheckpointFilePathSafe(".metadata");
        Path validFilePath = this.createCheckpointFilePathSafe(".valid");
        Path checkpointFilePath = this.createCheckpointFilePathSafe(".data");
        FSDataOutputStream metadataOutputStream = this.getFs().create(metadataFilePath);
        metadataOutputStream.writeInt(this.getPartitionStore().getNumPartitions());
        for (Integer partitionId : this.getPartitionStore().getPartitionIds()) {
            metadataOutputStream.writeInt(partitionId.intValue());
        }
        metadataOutputStream.close();
        this.storeCheckpointVertices();
        FSDataOutputStream checkpointOutputStream = this.getFs().create(checkpointFilePath);
        this.workerContext.write((DataOutput)checkpointOutputStream);
        this.getContext().progress();
        for (Integer partitionId : this.getPartitionStore().getPartitionIds()) {
            checkpointOutputStream.writeInt(partitionId.intValue());
            this.getServerData().getCurrentMessageStore().writePartition((DataOutput)checkpointOutputStream, partitionId);
            this.getContext().progress();
        }
        List<Writable> w2wMessages = this.getServerData().getCurrentWorkerToWorkerMessages();
        WritableUtils.writeList(w2wMessages, (DataOutput)checkpointOutputStream);
        checkpointOutputStream.close();
        this.getFs().createNewFile(validFilePath);
        String workerWroteCheckpoint = this.getWorkerWroteCheckpointPath(this.getApplicationAttempt(), this.getSuperstep()) + "/" + this.getHostnamePartitionId();
        try {
            this.getZkExt().createExt(workerWroteCheckpoint, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn((Object)("storeCheckpoint: wrote checkpoint worker path " + workerWroteCheckpoint + " already exists!"));
        }
        catch (KeeperException e) {
            throw new IllegalStateException("Creating " + workerWroteCheckpoint + " failed with KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Creating " + workerWroteCheckpoint + " failed with InterruptedException", e);
        }
    }

    private Path createCheckpointFilePathSafe(String name) throws IOException {
        Path validFilePath = new Path(this.getCheckpointBasePath(this.getSuperstep()) + "." + this.getTaskPartition() + name);
        if (this.getFs().delete(validFilePath, false)) {
            LOG.warn((Object)("storeCheckpoint: Removed " + name + " file " + validFilePath));
        }
        return validFilePath;
    }

    private Path getSavedCheckpoint(long superstep, String name) {
        return new Path(this.getSavedCheckpointBasePath(superstep) + "." + this.getTaskPartition() + name);
    }

    private void storeCheckpointVertices() {
        int numPartitions = this.getPartitionStore().getNumPartitions();
        int numThreads = Math.min(GiraphConstants.NUM_CHECKPOINT_IO_THREADS.get(this.getConfiguration()), numPartitions);
        final Queue partitionIdQueue = (Queue)((Object)(numPartitions == 0 ? new LinkedList() : new ArrayBlockingQueue(numPartitions)));
        Iterables.addAll((Collection)partitionIdQueue, this.getPartitionStore().getPartitionIds());
        final CompressionCodec codec = new CompressionCodecFactory(this.getConfiguration()).getCodec(new Path(GiraphConstants.CHECKPOINT_COMPRESSION_CODEC.get(this.getConfiguration())));
        long t0 = System.currentTimeMillis();
        CallableFactory<Void> callableFactory = new CallableFactory<Void>(){

            @Override
            public Callable<Void> newCallable(int callableId) {
                return new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Integer partitionId;
                        while (!partitionIdQueue.isEmpty() && (partitionId = (Integer)partitionIdQueue.poll()) != null) {
                            Path path = BspServiceWorker.this.createCheckpointFilePathSafe("_" + partitionId + ".vertices");
                            FSDataOutputStream uncompressedStream = BspServiceWorker.this.getFs().create(path);
                            Object stream = codec == null ? uncompressedStream : new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)uncompressedStream));
                            Partition partition = BspServiceWorker.this.getPartitionStore().getOrCreatePartition(partitionId);
                            partition.write((DataOutput)stream);
                            BspServiceWorker.this.getPartitionStore().putPartition(partition);
                            ((FilterOutputStream)stream).close();
                            uncompressedStream.close();
                        }
                        return null;
                    }
                };
            }
        };
        ProgressableUtils.getResultsWithNCallables(callableFactory, numThreads, "checkpoint-vertices-%d", (Progressable)this.getContext());
        LOG.info((Object)("Save checkpoint in " + (System.currentTimeMillis() - t0) + " ms, using " + numThreads + " threads"));
    }

    private void loadCheckpointVertices(final long superstep, List<Integer> partitions) {
        int numThreads = Math.min(GiraphConstants.NUM_CHECKPOINT_IO_THREADS.get(this.getConfiguration()), partitions.size());
        final ConcurrentLinkedQueue<Integer> partitionIdQueue = new ConcurrentLinkedQueue<Integer>(partitions);
        final CompressionCodec codec = new CompressionCodecFactory(this.getConfiguration()).getCodec(new Path(GiraphConstants.CHECKPOINT_COMPRESSION_CODEC.get(this.getConfiguration())));
        long t0 = System.currentTimeMillis();
        CallableFactory<Void> callableFactory = new CallableFactory<Void>(){

            @Override
            public Callable<Void> newCallable(int callableId) {
                return new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Integer partitionId;
                        while (!partitionIdQueue.isEmpty() && (partitionId = (Integer)partitionIdQueue.poll()) != null) {
                            Path path = BspServiceWorker.this.getSavedCheckpoint(superstep, "_" + partitionId + ".vertices");
                            FSDataInputStream compressedStream = BspServiceWorker.this.getFs().open(path);
                            Object stream = codec == null ? compressedStream : new DataInputStream((InputStream)codec.createInputStream((InputStream)compressedStream));
                            Partition partition = BspServiceWorker.this.getConfiguration().createPartition(partitionId, (Progressable)BspServiceWorker.this.getContext());
                            partition.readFields((DataInput)stream);
                            BspServiceWorker.this.getPartitionStore().addPartition(partition);
                            ((FilterInputStream)stream).close();
                        }
                        return null;
                    }
                };
            }
        };
        ProgressableUtils.getResultsWithNCallables(callableFactory, numThreads, "load-vertices-%d", (Progressable)this.getContext());
        LOG.info((Object)("Loaded checkpoint in " + (System.currentTimeMillis() - t0) + " ms, using " + numThreads + " threads"));
    }

    @Override
    public VertexEdgeCount loadCheckpoint(long superstep) {
        Path metadataFilePath = this.getSavedCheckpoint(superstep, ".metadata");
        Path checkpointFilePath = this.getSavedCheckpoint(superstep, ".data");
        try {
            FSDataInputStream metadataStream = this.getFs().open(metadataFilePath);
            int partitions = metadataStream.readInt();
            ArrayList<Integer> partitionIds = new ArrayList<Integer>(partitions);
            for (int i = 0; i < partitions; ++i) {
                int partitionId = metadataStream.readInt();
                partitionIds.add(partitionId);
            }
            this.loadCheckpointVertices(superstep, partitionIds);
            this.getContext().progress();
            metadataStream.close();
            FSDataInputStream checkpointStream = this.getFs().open(checkpointFilePath);
            this.workerContext.readFields((DataInput)checkpointStream);
            GlobalStats globalStats = new GlobalStats();
            SuperstepClasses superstepClasses = new SuperstepClasses();
            String finalizedCheckpointPath = this.getSavedCheckpointBasePath(superstep) + ".finalized";
            FSDataInputStream finalizedStream = this.getFs().open(new Path(finalizedCheckpointPath));
            globalStats.readFields((DataInput)finalizedStream);
            superstepClasses.readFields((DataInput)finalizedStream);
            this.getConfiguration().updateSuperstepClasses(superstepClasses);
            this.getServerData().resetMessageStores();
            for (int i = 0; i < partitions; ++i) {
                int partitionId = checkpointStream.readInt();
                this.getServerData().getCurrentMessageStore().readFieldsForPartition((DataInput)checkpointStream, partitionId);
            }
            List<? extends Writable> w2wMessages = WritableUtils.readList((DataInput)checkpointStream);
            this.getServerData().getCurrentWorkerToWorkerMessages().addAll(w2wMessages);
            checkpointStream.close();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("loadCheckpoint: Loaded " + this.workerGraphPartitioner.getPartitionOwners().size() + " total."));
            }
            this.workerClient.setup(this.getConfiguration().authenticate());
            return new VertexEdgeCount(globalStats.getVertexCount(), globalStats.getEdgeCount());
        }
        catch (IOException e) {
            throw new RuntimeException("loadCheckpoint: Failed for superstep=" + superstep, e);
        }
    }

    private void sendWorkerPartitions(Map<WorkerInfo, List<Integer>> workerPartitionMap) {
        ArrayList<Map.Entry<WorkerInfo, List<Integer>>> randomEntryList = new ArrayList<Map.Entry<WorkerInfo, List<Integer>>>(workerPartitionMap.entrySet());
        Collections.shuffle(randomEntryList);
        NettyWorkerClientRequestProcessor<I, V, E> workerClientRequestProcessor = new NettyWorkerClientRequestProcessor<I, V, E>(this.getContext(), this.getConfiguration(), this);
        for (Map.Entry entry : randomEntryList) {
            for (Integer partitionId : (List)entry.getValue()) {
                Partition<I, V, E> partition = this.getPartitionStore().removePartition(partitionId);
                if (partition == null) {
                    throw new IllegalStateException("sendWorkerPartitions: Couldn't find partition " + partitionId + " to send to " + entry.getKey());
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("sendWorkerPartitions: Sending worker " + entry.getKey() + " partition " + partitionId));
                }
                workerClientRequestProcessor.sendPartitionRequest((WorkerInfo)entry.getKey(), partition);
            }
        }
        try {
            workerClientRequestProcessor.flush();
            this.workerClient.waitAllRequests();
        }
        catch (IOException e) {
            throw new IllegalStateException("sendWorkerPartitions: Flush failed", e);
        }
        String myPartitionExchangeDonePath = this.getPartitionExchangeWorkerPath(this.getApplicationAttempt(), this.getSuperstep(), this.getWorkerInfo());
        try {
            this.getZkExt().createExt(myPartitionExchangeDonePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException keeperException) {
            throw new IllegalStateException("sendWorkerPartitions: KeeperException to create " + myPartitionExchangeDonePath, keeperException);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("sendWorkerPartitions: InterruptedException to create " + myPartitionExchangeDonePath, interruptedException);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"sendWorkerPartitions: Done sending all my partitions.");
        }
    }

    @Override
    public final void exchangeVertexPartitions(Collection<? extends PartitionOwner> masterSetPartitionOwners) {
        PartitionExchange partitionExchange = this.workerGraphPartitioner.updatePartitionOwners(this.getWorkerInfo(), masterSetPartitionOwners);
        this.workerClient.openConnections();
        Map<WorkerInfo, List<Integer>> sendWorkerPartitionMap = partitionExchange.getSendWorkerPartitionMap();
        if (!this.getPartitionStore().isEmpty()) {
            this.sendWorkerPartitions(sendWorkerPartitionMap);
        }
        Set<WorkerInfo> myDependencyWorkerSet = partitionExchange.getMyDependencyWorkerSet();
        HashSet<String> workerIdSet = new HashSet<String>();
        for (WorkerInfo tmpWorkerInfo : myDependencyWorkerSet) {
            if (workerIdSet.add(tmpWorkerInfo.getHostnameId())) continue;
            throw new IllegalStateException("exchangeVertexPartitions: Duplicate entry " + tmpWorkerInfo);
        }
        if (myDependencyWorkerSet.isEmpty() && this.getPartitionStore().isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"exchangeVertexPartitions: Nothing to exchange, exiting early");
            }
            return;
        }
        String vertexExchangePath = this.getPartitionExchangePath(this.getApplicationAttempt(), this.getSuperstep());
        try {
            while (true) {
                List<String> workerDoneList = this.getZkExt().getChildrenExt(vertexExchangePath, true, false, false);
                workerIdSet.removeAll(workerDoneList);
                if (!workerIdSet.isEmpty()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("exchangeVertexPartitions: Waiting for workers " + workerIdSet));
                    }
                    this.getPartitionExchangeChildrenChangedEvent().waitForever();
                    this.getPartitionExchangeChildrenChangedEvent().reset();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("exchangeVertexPartitions: Got runtime exception", e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"exchangeVertexPartitions: Done with exchange.");
        }
    }

    public final BspEvent getPartitionExchangeChildrenChangedEvent() {
        return this.partitionExchangeChildrenChanged;
    }

    @Override
    protected boolean processEvent(WatchedEvent event) {
        boolean foundEvent = false;
        if (event.getPath().startsWith(this.masterJobStatePath) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"processEvent: Job state changed, checking to see if it needs to restart");
            }
            JSONObject jsonObj = this.getJobState();
            if (this.getConfiguration().isPureYarnJob() && null == jsonObj) {
                LOG.error((Object)"BspServiceWorker#getJobState() came back NULL.");
                return false;
            }
            try {
                if (ApplicationState.valueOf(jsonObj.getString("_stateKey")) == ApplicationState.START_SUPERSTEP && jsonObj.getLong("_applicationAttemptKey") != this.getApplicationAttempt()) {
                    LOG.fatal((Object)("processEvent: Worker will restart from command - " + jsonObj.toString()));
                    System.exit(-1);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException("processEvent: Couldn't properly get job state from " + jsonObj.toString());
            }
            foundEvent = true;
        } else if (event.getPath().contains("/_partitionExchangeDir") && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"processEvent : partitionExchangeChildrenChanged (at least one worker is done sending partitions)");
            }
            this.partitionExchangeChildrenChanged.signal();
            foundEvent = true;
        }
        return foundEvent;
    }

    @Override
    public WorkerInfo getWorkerInfo() {
        return this.workerInfo;
    }

    @Override
    public PartitionStore<I, V, E> getPartitionStore() {
        return this.getServerData().getPartitionStore();
    }

    @Override
    public PartitionOwner getVertexPartitionOwner(I vertexId) {
        return this.workerGraphPartitioner.getPartitionOwner(vertexId);
    }

    @Override
    public Iterable<? extends PartitionOwner> getPartitionOwners() {
        return this.workerGraphPartitioner.getPartitionOwners();
    }

    @Override
    public int getPartitionId(I vertexId) {
        PartitionOwner partitionOwner = this.getVertexPartitionOwner(vertexId);
        return partitionOwner.getPartitionId();
    }

    @Override
    public boolean hasPartition(Integer partitionId) {
        return this.getPartitionStore().hasPartition(partitionId);
    }

    @Override
    public ServerData<I, V, E> getServerData() {
        return this.workerServer.getServerData();
    }

    @Override
    public WorkerAggregatorHandler getAggregatorHandler() {
        return this.globalCommHandler;
    }

    @Override
    public void prepareSuperstep() {
        if (this.getSuperstep() != -1L) {
            this.globalCommHandler.prepareSuperstep(this.workerAggregatorRequestProcessor);
        }
    }

    @Override
    public SuperstepOutput<I, V, E> getSuperstepOutput() {
        return this.superstepOutput;
    }

    @Override
    public GlobalStats getGlobalStats() {
        GlobalStats globalStats = new GlobalStats();
        if (this.getSuperstep() > Math.max(-1L, this.getRestartedSuperstep())) {
            String superstepFinishedNode = this.getSuperstepFinishedPath(this.getApplicationAttempt(), this.getSuperstep() - 1L);
            WritableUtils.readFieldsFromZnode(this.getZkExt(), superstepFinishedNode, false, null, globalStats);
        }
        return globalStats;
    }
}

