/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.WritableUtils;
import org.apache.giraph.utils.io.DataInputOutput;

public class ExtendedDataInputOutput
extends DataInputOutput {
    private final ImmutableClassesGiraphConfiguration conf;
    private ExtendedDataOutput dataOutput;

    public ExtendedDataInputOutput(ImmutableClassesGiraphConfiguration conf) {
        this.conf = conf;
        this.dataOutput = conf.createExtendedDataOutput();
    }

    @Override
    public DataOutput getDataOutput() {
        return this.dataOutput;
    }

    @Override
    public ExtendedDataInput createDataInput() {
        return this.conf.createExtendedDataInput(this.dataOutput.getByteArray(), 0, this.dataOutput.getPos());
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeExtendedDataOutput(this.dataOutput, out);
    }

    public void readFields(DataInput in) throws IOException {
        this.dataOutput = WritableUtils.readExtendedDataOutput(in, this.conf);
    }
}

