/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils.io;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.hadoop.io.Writable;

public class BigDataOutput
implements DataOutput,
Writable {
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private static final int MAX_SIZE = 0x2000000;
    private static final int SIZE_DELTA = 100;
    private ExtendedDataOutput currentDataOutput;
    private List<ExtendedDataOutput> dataOutputs;
    private final ImmutableClassesGiraphConfiguration conf;

    public BigDataOutput(ImmutableClassesGiraphConfiguration conf) {
        this(16, conf);
    }

    public BigDataOutput(int initialSize, ImmutableClassesGiraphConfiguration conf) {
        this.conf = conf;
        this.dataOutputs = null;
        this.currentDataOutput = conf.createExtendedDataOutput(initialSize);
    }

    private ExtendedDataOutput getDataOutputToWriteTo() {
        if (this.currentDataOutput.getPos() + 100 < 0x2000000) {
            return this.currentDataOutput;
        }
        if (this.dataOutputs == null) {
            this.dataOutputs = new ArrayList<ExtendedDataOutput>(1);
        }
        this.dataOutputs.add(this.currentDataOutput);
        this.currentDataOutput = this.conf.createExtendedDataOutput(0x2000000);
        return this.currentDataOutput;
    }

    public int getNumberOfDataOutputs() {
        return this.dataOutputs == null ? 1 : this.dataOutputs.size() + 1;
    }

    public Iterable<ExtendedDataOutput> getDataOutputs() {
        ArrayList currentList = Lists.newArrayList((Object[])new ExtendedDataOutput[]{this.currentDataOutput});
        if (this.dataOutputs == null) {
            return currentList;
        }
        return Iterables.concat(this.dataOutputs, (Iterable)currentList);
    }

    public ImmutableClassesGiraphConfiguration getConf() {
        return this.conf;
    }

    @Override
    public void write(int b) throws IOException {
        this.getDataOutputToWriteTo().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getDataOutputToWriteTo().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getDataOutputToWriteTo().write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.getDataOutputToWriteTo().writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.getDataOutputToWriteTo().writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.getDataOutputToWriteTo().writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.getDataOutputToWriteTo().writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.getDataOutputToWriteTo().writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.getDataOutputToWriteTo().writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.getDataOutputToWriteTo().writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.getDataOutputToWriteTo().writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.getDataOutputToWriteTo().writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.getDataOutputToWriteTo().writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.getDataOutputToWriteTo().writeUTF(s);
    }

    private void writeExtendedDataOutput(ExtendedDataOutput dataOutput, DataOutput out) throws IOException {
        out.writeInt(dataOutput.getPos());
        out.write(dataOutput.getByteArray(), 0, dataOutput.getPos());
    }

    private ExtendedDataOutput readExtendedDataOutput(DataInput in) throws IOException {
        int length = in.readInt();
        byte[] data = new byte[length];
        in.readFully(data);
        return this.conf.createExtendedDataOutput(data, data.length);
    }

    public void write(DataOutput out) throws IOException {
        if (this.dataOutputs == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.dataOutputs.size());
            for (ExtendedDataOutput stream : this.dataOutputs) {
                this.writeExtendedDataOutput(stream, out);
            }
        }
        this.writeExtendedDataOutput(this.currentDataOutput, out);
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            this.dataOutputs = null;
        } else {
            this.dataOutputs = new ArrayList<ExtendedDataOutput>(size);
            while (size-- > 0) {
                this.dataOutputs.add(this.readExtendedDataOutput(in));
            }
        }
        this.currentDataOutput = this.readExtendedDataOutput(in);
    }
}

