/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.utils.ExtendedByteArrayDataInput;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.io.BigDataOutput;

public class BigDataInput
implements ExtendedDataInput {
    private static final ExtendedDataInput EMPTY_INPUT = new ExtendedByteArrayDataInput(new byte[0]);
    private ExtendedDataInput currentInput;
    private final List<ExtendedDataInput> dataInputs;
    private int currentPositionInInputs;

    public BigDataInput(BigDataOutput bigDataOutput) {
        this.dataInputs = new ArrayList<ExtendedDataInput>(bigDataOutput.getNumberOfDataOutputs());
        for (ExtendedDataOutput dataOutput : bigDataOutput.getDataOutputs()) {
            this.dataInputs.add(bigDataOutput.getConf().createExtendedDataInput(dataOutput.getByteArray(), 0, dataOutput.getPos()));
        }
        this.currentPositionInInputs = -1;
        this.moveToNextDataInput();
    }

    private void moveToNextDataInput() {
        ++this.currentPositionInInputs;
        this.currentInput = this.currentPositionInInputs < this.dataInputs.size() ? this.dataInputs.get(this.currentPositionInInputs) : EMPTY_INPUT;
    }

    private void checkIfShouldMoveToNextDataInput() {
        if (this.currentInput.endOfInput()) {
            this.moveToNextDataInput();
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        this.currentInput.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        this.currentInput.readFully(b, off, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        this.checkIfShouldMoveToNextDataInput();
        return this.currentInput.readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int bytesLeftToSkip = n;
        while (bytesLeftToSkip > 0) {
            int bytesSkipped;
            if ((bytesLeftToSkip -= (bytesSkipped = this.currentInput.skipBytes(bytesLeftToSkip))) <= 0) continue;
            this.moveToNextDataInput();
            if (!this.endOfInput()) continue;
            break;
        }
        return n - bytesLeftToSkip;
    }

    @Override
    public int getPos() {
        int pos = 0;
        for (int i = 0; i <= this.currentPositionInInputs; ++i) {
            pos += this.dataInputs.get(i).getPos();
        }
        return pos;
    }

    @Override
    public int available() {
        throw new UnsupportedOperationException("available: Not supported with BigDataIO because overflow can happen");
    }

    @Override
    public boolean endOfInput() {
        return this.currentInput == EMPTY_INPUT || this.dataInputs.get(this.currentPositionInInputs).endOfInput() && this.currentPositionInInputs == this.dataInputs.size() - 1;
    }
}

