/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.yourkit.api.Controller;
import org.apache.giraph.utils.YourKitContext;
import org.apache.log4j.Logger;

public class YourKitProfiler {
    private static final Logger LOG = Logger.getLogger(YourKitProfiler.class);
    private static final int ALLOCATION_RECORDING_INTERVAL = 1000;

    protected YourKitProfiler() {
    }

    public static YourKitContext startProfile(boolean enableStackTelemetry, boolean enableCPUProfilling, boolean enableAllocationRecording) {
        Controller controller;
        try {
            controller = new Controller();
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to set up YourKit controller", (Throwable)e);
            return null;
        }
        try {
            if (enableStackTelemetry) {
                controller.enableStackTelemetry();
                LOG.info((Object)"Enabled Yourkit stack telemetry");
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to enable YourKit stack telemetry", (Throwable)e);
        }
        try {
            if (enableCPUProfilling) {
                controller.startCPUProfiling(4L, "$Dispatch*\n$Http*\n$Markup*\n$Page*\n$Property*\n$Proxy*\n$Request*\n+*TapestryFilter*\n+com.ibm.websphere.samples.*\n+org.apache.jsp.*\n+org.apache.maven.*\n+org.codehaus.groovy.runtime.DefaultGroovyMethods\n+org.codehaus.groovy.runtime.DefaultGroovyStaticMethods\nallaire.jrun*\nantlr.*\napple.*\natg.*\nbsh.*\nc8*\ncom.acumenat.*\ncom.adventnet.*\ncom.apple.*\ncom.asn1c.*\ncom.bea.*\ncom.beasys.*\ncom.borland.*\ncom.caucho.*\ncom.certicom.*\nCOM.cloudscape.*\ncom.evermind.*\ncom.ibm.*\ncom.inprise.*\ncom.intellij.rt.execution.*\ncom.iplanet.*\ncom.livesoftware*\ncom.netscape.server.http.*\nCOM.objectspace.*\ncom.octetstring.*\ncom.orionserver.*\ncom.phaos.*\ncom.pointbase.*\nCOM.rsa.*\ncom.rsa.*\ncom.sssw.*\ncom.sun.*\ncom.sybase.*\ncom.unify.*\ncom.visigenic.*\ncom.yourkit.probes.*\ncom.yourkit.runtime.*\ncompressionFilters.*\nfilters.*\ngnu.*\ngroovy.lang.*\ngroovyjarjarasm.*\njava.*\njavax.*\njrockit.*\njrun.*\njrunx.*\njunit.*\nlisteners.*\nnetscape.*\nnewatlanta.servletexec.*\norg.apache.*\norg.codehaus.groovy.*\norg.eclipse.*\norg.enhydra.*\norg.hsql.*\norg.jboss.*\norg.jbossmq.*\norg.mozilla.*\norg.omg.CORBA.*\norg.omg.CosNaming.*\norg.w3c.*\norg.xml.*\nsolid.*\nssa.*\nsun.*\nsunw.*\nweblogic.*", "java.io.RandomAccessFile : readBytes(byte[], int, int)\njava.io.RandomAccessFile : read()\njava.io.RandomAccessFile : write(int)\njava.io.RandomAccessFile : writeBytes(byte[], int, int)\njava.net.SocketInputStream : socketRead0(java.io.FileDescriptor, byte[], int, int, int)\njava.net.SocketOutputStream : socketWrite0(java.io.FileDescriptor, byte[], int, int)\n");
                LOG.info((Object)"Started YourKit CPU profiling");
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to start YourKit CPU profiling", (Throwable)e);
        }
        try {
            if (enableAllocationRecording) {
                controller.startAllocationRecording(true, 1000, false, -1, true, false);
                LOG.info((Object)"Started YourKit allocation recording");
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to start YourKit allocation recording", (Throwable)e);
        }
        return new YourKitContext(controller);
    }
}

