/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.yourkit.api.Controller;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public class YourKitContext {
    private static final Logger LOG = Logger.getLogger(YourKitContext.class);
    private static Joiner SLASH_JOINER = Joiner.on((String)"/");
    private final Controller yourKitController;

    YourKitContext(Controller yourKitController) {
        this.yourKitController = yourKitController;
    }

    private void snapshot(long flags, String destPath) {
        if (this.yourKitController != null) {
            String path;
            try {
                path = this.yourKitController.captureSnapshot(flags);
            }
            catch (Exception e) {
                return;
            }
            try {
                File destFile = new File(destPath);
                Files.createParentDirs((File)destFile);
                Files.move((File)new File(path), (File)destFile);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to move YourKit snapshot file from " + path + " to " + destPath), (Throwable)e);
            }
        }
    }

    public void snapshotWithMemory(String destPath) {
        this.snapshot(1L, destPath);
    }

    public void snapshotWithMemory(Mapper.Context context, String name) {
        this.snapshot(1L, SLASH_JOINER.join((Object)System.getProperty("hadoop.log.dir", "/tmp"), (Object)"userlogs", new Object[]{context.getTaskAttemptID(), name + ".snapshot"}));
    }

    public void snapshotCPUOnly(String destPath) {
        this.snapshot(0L, destPath);
    }

    public void snapshotCPUOnly(Mapper.Context context, String name) {
        this.snapshot(0L, SLASH_JOINER.join((Object)System.getProperty("hadoop.log.dir", "/tmp"), (Object)"userlogs", new Object[]{context.getTaskAttemptID(), name + ".snapshot"}));
    }

    public void stop() {
        if (this.yourKitController != null) {
            try {
                this.yourKitController.disableStackTelemetry();
                LOG.info((Object)"Disabled YourKit stack telemetry");
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to stop stack telemetry", (Throwable)e);
            }
            try {
                this.yourKitController.stopCPUProfiling();
                LOG.info((Object)"Stopped Yourkit CPU profiling");
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to stop YourKit profiling", (Throwable)e);
            }
            try {
                this.yourKitController.stopAllocationRecording();
                LOG.info((Object)"Stopped Yourkit allocation recording");
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to stop YourKit allocation recording", (Throwable)e);
            }
        }
    }
}

