/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.ConfigurationUtils;
import org.apache.giraph.utils.ExtendedByteArrayDataInput;
import org.apache.giraph.utils.ExtendedByteArrayDataOutput;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.utils.UnsafeByteArrayInputStream;
import org.apache.giraph.utils.UnsafeByteArrayOutputStream;
import org.apache.giraph.utils.UnsafeReusableByteArrayInput;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class WritableUtils {
    private WritableUtils() {
    }

    public static <W extends Writable> W createWritable(Class<W> klass) {
        if (NullWritable.class.equals(klass)) {
            return (W)NullWritable.get();
        }
        return (W)((Writable)ReflectionUtils.newInstance(klass));
    }

    public static <W extends Writable> W createWritable(Class<W> klass, ImmutableClassesGiraphConfiguration configuration) {
        W result = WritableUtils.createWritable(klass);
        ConfigurationUtils.configureIfPossible(result, configuration);
        return result;
    }

    public static void readFieldsFromByteArray(byte[] byteArray, Writable ... writableObjects) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(byteArray));
        try {
            for (Writable writableObject : writableObjects) {
                writableObject.readFields((DataInput)inputStream);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("readFieldsFromByteArray: IOException", e);
        }
    }

    public static void readFieldsFromZnode(ZooKeeperExt zkExt, String zkPath, boolean watch, Stat stat, Writable ... writableObjects) {
        try {
            byte[] zkData = zkExt.getData(zkPath, false, stat);
            WritableUtils.readFieldsFromByteArray(zkData, writableObjects);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("readFieldsFromZnode: KeeperException on " + zkPath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("readFieldsFromZnode: InterrruptedStateException on " + zkPath, e);
        }
    }

    public static byte[] writeToByteArray(Writable ... writableObjects) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(outputStream);
        try {
            for (Writable writableObject : writableObjects) {
                writableObject.write((DataOutput)output);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("writeToByteArray: IOStateException", e);
        }
        return outputStream.toByteArray();
    }

    public static void readFieldsFromByteArrayWithSize(byte[] byteArray, Writable writableObject, boolean unsafe) {
        ExtendedDataInput extendedDataInput = unsafe ? new UnsafeByteArrayInputStream(byteArray) : new ExtendedByteArrayDataInput(byteArray);
        try {
            extendedDataInput.readInt();
            writableObject.readFields((DataInput)extendedDataInput);
        }
        catch (IOException e) {
            throw new IllegalStateException("readFieldsFromByteArrayWithSize: IOException", e);
        }
    }

    public static byte[] writeToByteArrayWithSize(Writable writableObject, boolean unsafe) {
        return WritableUtils.writeToByteArrayWithSize(writableObject, null, unsafe);
    }

    public static byte[] writeToByteArrayWithSize(Writable writableObject, byte[] buffer, boolean unsafe) {
        OutputStream extendedDataOutput = unsafe ? new UnsafeByteArrayOutputStream(buffer) : new ExtendedByteArrayDataOutput(buffer);
        try {
            extendedDataOutput.writeInt(-1);
            writableObject.write((DataOutput)((Object)extendedDataOutput));
            extendedDataOutput.writeInt(0, extendedDataOutput.getPos());
        }
        catch (IOException e) {
            throw new IllegalStateException("writeToByteArrayWithSize: IOException", e);
        }
        return extendedDataOutput.getByteArray();
    }

    public static ZooKeeperExt.PathStat writeToZnode(ZooKeeperExt zkExt, String zkPath, int version, Writable ... writableObjects) {
        try {
            byte[] byteArray = WritableUtils.writeToByteArray(writableObjects);
            return zkExt.createOrSetExt(zkPath, byteArray, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true, version);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("writeToZnode: KeeperException on " + zkPath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("writeToZnode: InterruptedException on " + zkPath, e);
        }
    }

    public static byte[] writeListToByteArray(List<? extends Writable> writableList) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(outputStream);
        try {
            output.writeInt(writableList.size());
            for (Writable writable : writableList) {
                writable.write((DataOutput)output);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("writeListToByteArray: IOException", e);
        }
        return outputStream.toByteArray();
    }

    public static ZooKeeperExt.PathStat writeListToZnode(ZooKeeperExt zkExt, String zkPath, int version, List<? extends Writable> writableList) {
        try {
            return zkExt.createOrSetExt(zkPath, WritableUtils.writeListToByteArray(writableList), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true, version);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("writeListToZnode: KeeperException on " + zkPath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("writeListToZnode: InterruptedException on " + zkPath, e);
        }
    }

    public static <T extends Writable> List<T> readListFieldsFromByteArray(byte[] byteArray, Class<? extends T> writableClass, Configuration conf) {
        try {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(byteArray));
            int size = inputStream.readInt();
            ArrayList<Writable> writableList = new ArrayList<Writable>(size);
            for (int i = 0; i < size; ++i) {
                Writable writable = (Writable)org.apache.hadoop.util.ReflectionUtils.newInstance(writableClass, (Configuration)conf);
                writable.readFields((DataInput)inputStream);
                writableList.add(writable);
            }
            return writableList;
        }
        catch (IOException e) {
            throw new IllegalStateException("readListFieldsFromZnode: IOException", e);
        }
    }

    public static <T extends Writable> List<T> readListFieldsFromZnode(ZooKeeperExt zkExt, String zkPath, boolean watch, Stat stat, Class<? extends T> writableClass, Configuration conf) {
        try {
            byte[] zkData = zkExt.getData(zkPath, false, stat);
            return WritableUtils.readListFieldsFromByteArray(zkData, writableClass, conf);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("readListFieldsFromZnode: KeeperException on " + zkPath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("readListFieldsFromZnode: InterruptedException on " + zkPath, e);
        }
    }

    public static void writeExtendedDataOutput(ExtendedDataOutput extendedDataOutput, DataOutput out) throws IOException {
        out.writeInt(extendedDataOutput.getPos());
        out.write(extendedDataOutput.getByteArray(), 0, extendedDataOutput.getPos());
    }

    public static ExtendedDataOutput readExtendedDataOutput(DataInput in, ImmutableClassesGiraphConfiguration conf) throws IOException {
        int size = in.readInt();
        byte[] buf = new byte[size];
        in.readFully(buf);
        return conf.createExtendedDataOutput(buf, size);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> byte[] writeVertexToByteArray(Vertex<I, V, E> vertex, byte[] buffer, boolean unsafe, ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        OutputStream extendedDataOutput = unsafe ? new UnsafeByteArrayOutputStream(buffer) : new ExtendedByteArrayDataOutput(buffer);
        try {
            extendedDataOutput.writeInt(-1);
            WritableUtils.writeVertexToDataOutput((DataOutput)((Object)extendedDataOutput), vertex, conf);
            extendedDataOutput.writeInt(0, extendedDataOutput.getPos());
        }
        catch (IOException e) {
            throw new IllegalStateException("writeVertexToByteArray: IOException", e);
        }
        return extendedDataOutput.getByteArray();
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> byte[] writeVertexToByteArray(Vertex<I, V, E> vertex, boolean unsafe, ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        return WritableUtils.writeVertexToByteArray(vertex, null, unsafe, conf);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> void reinitializeVertexFromByteArray(byte[] byteArray, Vertex<I, V, E> vertex, boolean unsafe, ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        ExtendedDataInput extendedDataInput = unsafe ? new UnsafeByteArrayInputStream(byteArray) : new ExtendedByteArrayDataInput(byteArray);
        try {
            extendedDataInput.readInt();
            WritableUtils.reinitializeVertexFromDataInput(extendedDataInput, vertex, conf);
        }
        catch (IOException e) {
            throw new IllegalStateException("readFieldsFromByteArrayWithSize: IOException", e);
        }
    }

    public static <I extends WritableComparable, E extends Writable> void writeEdge(DataOutput out, Edge<I, E> edge) throws IOException {
        edge.getTargetVertexId().write(out);
        edge.getValue().write(out);
    }

    public static <I extends WritableComparable, E extends Writable> void readEdge(DataInput in, Edge<I, E> edge) throws IOException {
        edge.getTargetVertexId().readFields(in);
        edge.getValue().readFields(in);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> void reinitializeVertexFromDataInput(DataInput input, Vertex<I, V, E> vertex, ImmutableClassesGiraphConfiguration<I, V, E> conf) throws IOException {
        vertex.getId().readFields(input);
        vertex.getValue().readFields(input);
        ((OutEdges)vertex.getEdges()).readFields(input);
        if (input.readBoolean()) {
            vertex.voteToHalt();
        } else {
            vertex.wakeUp();
        }
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> Vertex<I, V, E> readVertexFromDataInput(DataInput input, ImmutableClassesGiraphConfiguration<I, V, E> conf) throws IOException {
        Vertex<I, V, E> vertex = conf.createVertex();
        I id = conf.createVertexId();
        V value = conf.createVertexValue();
        OutEdges<I, E> edges = conf.createOutEdges();
        vertex.initialize(id, value, edges);
        WritableUtils.reinitializeVertexFromDataInput(input, vertex, conf);
        return vertex;
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> void writeVertexToDataOutput(DataOutput output, Vertex<I, V, E> vertex, ImmutableClassesGiraphConfiguration<I, V, E> conf) throws IOException {
        vertex.getId().write(output);
        vertex.getValue().write(output);
        ((OutEdges)vertex.getEdges()).write(output);
        output.writeBoolean(vertex.isHalted());
    }

    public static <T> void writeClass(Class<T> clazz, DataOutput output) throws IOException {
        output.writeBoolean(clazz != null);
        if (clazz != null) {
            output.writeUTF(clazz.getName());
        }
    }

    public static <T> Class<T> readClass(DataInput input) throws IOException {
        if (input.readBoolean()) {
            String className = input.readUTF();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("readClass: No class found " + className);
            }
        }
        return null;
    }

    public static void writeWritableObject(Writable object, DataOutput output) throws IOException {
        output.writeBoolean(object != null);
        if (object != null) {
            output.writeUTF(object.getClass().getName());
            object.write(output);
        }
    }

    public static <T extends Writable> T readWritableObject(DataInput input, ImmutableClassesGiraphConfiguration conf) throws IOException {
        if (input.readBoolean()) {
            String className = input.readUTF();
            try {
                Writable object = (Writable)ReflectionUtils.newInstance(Class.forName(className), conf);
                object.readFields(input);
                return (T)object;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("readWritableObject: No class found " + className);
            }
        }
        return null;
    }

    public static void writeList(List<? extends Writable> list, DataOutput output) throws IOException {
        output.writeBoolean(list != null);
        if (list != null) {
            output.writeInt(list.size());
            Class<?> clazz = null;
            for (Writable writable : list) {
                output.writeBoolean(writable == null);
                if (writable == null) continue;
                if (writable.getClass() != clazz) {
                    clazz = writable.getClass();
                    output.writeBoolean(true);
                    WritableUtils.writeClass(clazz, output);
                } else {
                    output.writeBoolean(false);
                }
                writable.write(output);
            }
        }
    }

    public static List<? extends Writable> readList(DataInput input) throws IOException {
        try {
            ArrayList<Writable> res = null;
            if (input.readBoolean()) {
                int size = input.readInt();
                res = new ArrayList<Writable>(size);
                Class clazz = null;
                for (int i = 0; i < size; ++i) {
                    boolean isNull = input.readBoolean();
                    if (isNull) {
                        res.add(null);
                        continue;
                    }
                    boolean hasClassInfo = input.readBoolean();
                    if (hasClassInfo) {
                        clazz = WritableUtils.readClass(input);
                    }
                    Writable element = (Writable)clazz.newInstance();
                    element.readFields(input);
                    res.add(element);
                }
            }
            return res;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("unable to instantiate object", e);
        }
    }

    public static <T extends Writable> T createCopy(UnsafeByteArrayOutputStream reusableOut, UnsafeReusableByteArrayInput reusableIn, T original, ImmutableClassesGiraphConfiguration conf) {
        Object copy = WritableUtils.createWritable(original.getClass(), conf);
        try {
            reusableOut.reset();
            original.write((DataOutput)reusableOut);
            reusableIn.initialize(reusableOut.getByteArray(), 0, reusableOut.getPos());
            copy.readFields((DataInput)reusableIn);
            if (reusableIn.available() != 0) {
                throw new RuntimeException("Serialization of " + original.getClass() + " encountered issues, " + reusableIn.available() + " bytes left to be read");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException occurred while trying to create a copy " + original.getClass(), e);
        }
        return (T)copy;
    }

    public static void writeIntArray(int[] array, DataOutput dataOutput) throws IOException {
        if (array != null) {
            dataOutput.writeInt(array.length);
            for (int r : array) {
                dataOutput.writeInt(r);
            }
        } else {
            dataOutput.writeInt(-1);
        }
    }

    public static int[] readIntArray(DataInput dataInput) throws IOException {
        int[] res = null;
        int size = dataInput.readInt();
        if (size >= 0) {
            res = new int[size];
            for (int i = 0; i < size; ++i) {
                res[i] = dataInput.readInt();
            }
        }
        return res;
    }

    public static void writeLongArray(DataOutput dataOutput, long[] array) throws IOException {
        if (array != null) {
            dataOutput.writeInt(array.length);
            for (long r : array) {
                dataOutput.writeLong(r);
            }
        } else {
            dataOutput.writeInt(-1);
        }
    }

    public static long[] readLongArray(DataInput dataInput) throws IOException {
        long[] res = null;
        int size = dataInput.readInt();
        if (size >= 0) {
            res = new long[size];
            for (int i = 0; i < size; ++i) {
                res[i] = dataInput.readLong();
            }
        }
        return res;
    }
}

