/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class VertexIterator<I extends WritableComparable, V extends Writable, E extends Writable> {
    private final ExtendedDataInput extendedDataInput;
    private Vertex<I, V, E> vertex;
    private final ImmutableClassesGiraphConfiguration<I, V, E> configuration;

    public VertexIterator(ExtendedDataOutput extendedDataOutput, ImmutableClassesGiraphConfiguration<I, V, E> configuration) {
        this.extendedDataInput = configuration.createExtendedDataInput(extendedDataOutput.getByteArray(), 0, extendedDataOutput.getPos());
        this.configuration = configuration;
        this.resetEmptyVertex();
    }

    private void resetEmptyVertex() {
        this.vertex = this.configuration.createVertex();
        I id = this.configuration.createVertexId();
        V value = this.configuration.createVertexValue();
        OutEdges<I, E> edges = this.configuration.createOutEdges();
        this.vertex.initialize(id, value, edges);
    }

    public boolean hasNext() {
        return !this.extendedDataInput.endOfInput();
    }

    public void next() {
        if (this.vertex == null) {
            this.resetEmptyVertex();
        }
        if (this.vertex.getId() == null) {
            this.vertex.initialize(this.configuration.createVertexId(), this.vertex.getValue());
        }
        try {
            WritableUtils.reinitializeVertexFromDataInput(this.extendedDataInput, this.vertex, this.configuration);
        }
        catch (IOException e) {
            throw new IllegalStateException("next: IOException", e);
        }
    }

    public I getCurrentVertexId() {
        return this.vertex.getId();
    }

    public I releaseCurrentVertexId() {
        I releasedVertexId = this.vertex.getId();
        this.vertex.initialize(null, this.vertex.getValue());
        return releasedVertexId;
    }

    public Vertex<I, V, E> getVertex() {
        return this.vertex;
    }

    public Vertex<I, V, E> releaseVertex() {
        Vertex<I, V, E> releasedVertex = this.vertex;
        this.vertex = null;
        return releasedVertex;
    }
}

