/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class VerboseByteStructMessageWrite {
    private VerboseByteStructMessageWrite() {
    }

    public static <I extends WritableComparable, M extends Writable> void verboseWriteCurrentMessage(VertexIdMessageIterator<I, M> iterator, DataOutput out) throws IOException {
        try {
            iterator.getCurrentMessage().write(out);
        }
        catch (NegativeArraySizeException e) {
            VerboseByteStructMessageWrite.handleNegativeArraySize(iterator.getCurrentVertexId());
        }
    }

    public static <I extends WritableComparable> void handleNegativeArraySize(I vertexId) {
        throw new RuntimeException("The numbers of bytes sent to vertex " + vertexId + " exceeded the max capacity of " + "its ExtendedDataOutput. Please consider setting " + "giraph.useBigDataIOForMessages=true. If there are super-vertices" + " in the graph which receive a lot of messages (total serialized " + "size of messages goes beyond the maximum size of a byte array), " + "setting this option to true will remove that limit");
    }
}

