/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import java.io.UTFDataFormatException;
import org.apache.giraph.utils.ExtendedDataInput;

public abstract class UnsafeReads
implements ExtendedDataInput {
    protected int bufLength;
    protected long pos = 0L;

    public UnsafeReads(int length) {
        this.bufLength = length;
    }

    public UnsafeReads(long offset, int length) {
        this.pos = offset;
        this.bufLength = length;
    }

    @Override
    public abstract int available();

    @Override
    public abstract int getPos();

    protected void ensureRemaining(int requiredBytes) throws IOException {
        if (this.available() < requiredBytes) {
            throw new IOException("ensureRemaining: Only " + this.available() + " bytes remaining, trying to read " + requiredBytes);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.ensureRemaining(n);
        this.pos += (long)n;
        return n;
    }

    @Override
    public String readLine() throws IOException {
        byte c;
        char[] tmpBuf = new char[128];
        int room = tmpBuf.length;
        int offset = 0;
        block4: while (true) {
            c = this.readByte();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    byte c2 = this.readByte();
                    if (c2 == 10 || c2 == -1) break block4;
                    --this.pos;
                    break block4;
                }
                default: {
                    if (--room < 0) {
                        char[] replacebuf = new char[offset + 128];
                        room = replacebuf.length - offset - 1;
                        System.arraycopy(tmpBuf, 0, replacebuf, 0, offset);
                        tmpBuf = replacebuf;
                    }
                    tmpBuf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(tmpBuf, 0, offset);
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararrCount = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }
}

