/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.giraph.utils.ExtendedDataOutput;
import sun.misc.Unsafe;

public class UnsafeByteArrayOutputStream
extends OutputStream
implements ExtendedDataOutput {
    private static final int DEFAULT_BYTES = 32;
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    private byte[] buf;
    private int pos = 0;

    public UnsafeByteArrayOutputStream() {
        this(32);
    }

    public UnsafeByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    public UnsafeByteArrayOutputStream(byte[] buf) {
        this.buf = buf == null ? new byte[32] : buf;
    }

    public UnsafeByteArrayOutputStream(byte[] buf, int pos) {
        this(buf);
        this.pos = pos;
    }

    private void ensureSize(int size) {
        if (this.pos + size > this.buf.length) {
            byte[] newBuf = new byte[this.buf.length + size << 1];
            System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
            this.buf = newBuf;
        }
    }

    @Override
    public byte[] getByteArray() {
        return this.buf;
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    @Override
    public byte[] toByteArray(int offset, int length) {
        if (offset + length > this.pos) {
            throw new IndexOutOfBoundsException(String.format("Offset: %d + Length: %d exceeds the size of buf : %d", offset, length, this.pos));
        }
        return Arrays.copyOfRange(this.buf, offset, length);
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureSize(1);
        this.buf[this.pos] = (byte)b;
        ++this.pos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.ensureSize(b.length);
        System.arraycopy(b, 0, this.buf, this.pos, b.length);
        this.pos += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureSize(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureSize(1);
        UNSAFE.putBoolean(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, v);
        ++this.pos;
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureSize(1);
        UNSAFE.putByte(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, (byte)v);
        ++this.pos;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureSize(2);
        UNSAFE.putShort(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, (short)v);
        this.pos += 2;
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureSize(2);
        UNSAFE.putChar(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, (char)v);
        this.pos += 2;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureSize(4);
        UNSAFE.putInt(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, v);
        this.pos += 4;
    }

    @Override
    public void ensureWritable(int minSize) {
        if (this.pos + minSize > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, this.pos + minSize));
        }
    }

    @Override
    public void skipBytes(int bytesToSkip) {
        this.ensureWritable(bytesToSkip);
        this.pos += bytesToSkip;
    }

    @Override
    public void writeInt(int pos, int value) {
        if (pos + 4 > this.pos) {
            throw new IndexOutOfBoundsException("writeInt: Tried to write int to position " + pos + " but current length is " + this.pos);
        }
        UNSAFE.putInt(this.buf, BYTE_ARRAY_OFFSET + (long)pos, value);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureSize(8);
        UNSAFE.putLong(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, v);
        this.pos += 8;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.ensureSize(4);
        UNSAFE.putFloat(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, v);
        this.pos += 4;
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.ensureSize(8);
        UNSAFE.putDouble(this.buf, BYTE_ARRAY_OFFSET + (long)this.pos, v);
        this.pos += 8;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.ensureSize(len);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeByte(v);
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.ensureSize(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(v);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        char c;
        int i;
        int strlen = s.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.ensureSize(utflen + 2);
        this.writeShort(utflen);
        i = 0;
        for (i = 0; i < strlen && (c = s.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.buf[this.pos++] = (byte)c;
        }
        while (i < strlen) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buf[this.pos++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buf[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.buf[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buf[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("UnsafeByteArrayOutputStream: Failed to get unsafe", e);
        }
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    }
}

