/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.giraph.utils.UnsafeReads;
import sun.misc.Unsafe;

public class UnsafeArrayReads
extends UnsafeReads {
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    protected byte[] buf;

    public UnsafeArrayReads(byte[] buf) {
        super(buf.length);
        this.buf = buf;
    }

    public UnsafeArrayReads(byte[] buf, int offset, int length) {
        super(offset, length);
        this.buf = buf;
    }

    @Override
    public int available() {
        return (int)((long)this.bufLength - this.pos);
    }

    @Override
    public boolean endOfInput() {
        return this.available() == 0;
    }

    @Override
    public int getPos() {
        return (int)this.pos;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.ensureRemaining(b.length);
        System.arraycopy(this.buf, (int)this.pos, b, 0, b.length);
        this.pos += (long)b.length;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.ensureRemaining(len);
        System.arraycopy(this.buf, (int)this.pos, b, off, len);
        this.pos += (long)len;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.ensureRemaining(1);
        boolean value = UNSAFE.getBoolean(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        ++this.pos;
        return value;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureRemaining(1);
        byte value = UNSAFE.getByte(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        ++this.pos;
        return value;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShort() throws IOException {
        this.ensureRemaining(2);
        short value = UNSAFE.getShort(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        this.pos += 2L;
        return value;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.ensureRemaining(2);
        char value = UNSAFE.getChar(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        this.pos += 2L;
        return value;
    }

    @Override
    public int readInt() throws IOException {
        this.ensureRemaining(4);
        int value = UNSAFE.getInt(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        this.pos += 4L;
        return value;
    }

    @Override
    public long readLong() throws IOException {
        this.ensureRemaining(8);
        long value = UNSAFE.getLong(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        this.pos += 8L;
        return value;
    }

    @Override
    public float readFloat() throws IOException {
        this.ensureRemaining(4);
        float value = UNSAFE.getFloat(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        this.pos += 4L;
        return value;
    }

    @Override
    public double readDouble() throws IOException {
        this.ensureRemaining(8);
        double value = UNSAFE.getDouble(this.buf, BYTE_ARRAY_OFFSET + this.pos);
        this.pos += 8L;
        return value;
    }

    public static int getInt(byte[] buf, int pos) {
        return UNSAFE.getInt(buf, BYTE_ARRAY_OFFSET + (long)pos);
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("UnsafeArrayReads: Failed to get unsafe", e);
        }
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    }
}

