/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import org.apache.log4j.Logger;

public class TimedLogger {
    private volatile long lastPrint = System.currentTimeMillis();
    private final int msecs;
    private final Logger log;

    public TimedLogger(int msecs, Logger log) {
        this.msecs = msecs;
        this.log = log;
    }

    public void info(String msg) {
        if (this.isPrintable()) {
            this.log.info((Object)msg);
        }
    }

    public boolean isPrintable() {
        if (System.currentTimeMillis() > this.lastPrint + (long)this.msecs) {
            this.lastPrint = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

