/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class TestGraph<I extends WritableComparable, V extends Writable, E extends Writable>
implements Iterable<Vertex<I, V, E>> {
    protected HashMap<I, Vertex<I, V, E>> vertices = Maps.newHashMap();
    protected ImmutableClassesGiraphConfiguration<I, V, E> conf;

    public TestGraph(GiraphConfiguration conf) {
        this.conf = new ImmutableClassesGiraphConfiguration(conf);
    }

    public HashMap<I, Vertex<I, V, E>> getVertices() {
        return this.vertices;
    }

    public void clear() {
        this.vertices.clear();
    }

    public TestGraph<I, V, E> addVertex(Vertex<I, V, E> vertex) {
        this.vertices.put(vertex.getId(), vertex);
        return this;
    }

    public TestGraph<I, V, E> addVertex(I id, V value, Map.Entry<I, E> ... edges) {
        Vertex<I, V, E> v = this.makeVertex(id, value, edges);
        this.vertices.put(id, v);
        return this;
    }

    public TestGraph<I, V, E> addEdge(I vertexId, Map.Entry<I, E> edgePair) {
        if (!this.vertices.containsKey(vertexId)) {
            Vertex<I, V, E> v = this.conf.createVertex();
            v.initialize(vertexId, this.conf.createVertexValue());
            this.vertices.put(vertexId, v);
        }
        this.vertices.get(vertexId).addEdge(EdgeFactory.create((WritableComparable)edgePair.getKey(), (Writable)edgePair.getValue()));
        return this;
    }

    public TestGraph<I, V, E> addEdge(I vertexId, I toVertex, E edgeValue) {
        if (!this.vertices.containsKey(vertexId)) {
            Vertex<I, V, E> v = this.conf.createVertex();
            v.initialize(vertexId, this.conf.createVertexValue());
            this.vertices.put(vertexId, v);
        }
        this.vertices.get(vertexId).addEdge(EdgeFactory.create(toVertex, edgeValue));
        return this;
    }

    public Iterator<I> idIterator() {
        return this.vertices.keySet().iterator();
    }

    @Override
    public Iterator<Vertex<I, V, E>> iterator() {
        return this.vertices.values().iterator();
    }

    public Vertex<I, V, E> getVertex(I id) {
        return this.vertices.get(id);
    }

    protected Iterable<Edge<I, E>> createEdges(Map.Entry<I, E> ... destEdgess) {
        ArrayList edgesList = Lists.newArrayList();
        for (Map.Entry<I, E> e : destEdgess) {
            edgesList.add(EdgeFactory.create((WritableComparable)e.getKey(), (Writable)e.getValue()));
        }
        return edgesList;
    }

    protected Vertex<I, V, E> makeVertex(I id, V value, Map.Entry<I, E> ... edges) {
        Vertex<I, V, E> vertex = this.conf.createVertex();
        vertex.initialize(id, value, this.createEdges(edges));
        return vertex;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("vertices", this.vertices).toString();
    }
}

