/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.giraph.utils.TimedLogger;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class TaskIdsPermitsBarrier {
    private static final Logger LOG = Logger.getLogger(TaskIdsPermitsBarrier.class);
    private static final int MSEC_PERIOD = 10000;
    private static final int MAX_TASK_IDS_TO_LOG = 10;
    private final Progressable progressable;
    private long waitingOnPermits = 0L;
    private final Set<Integer> arrivedTaskIds = new HashSet<Integer>();
    private final TimedLogger logger;

    public TaskIdsPermitsBarrier(Progressable progressable) {
        this.progressable = progressable;
        this.logger = new TimedLogger(10000, LOG);
    }

    public synchronized void waitForRequiredPermits(Set<Integer> expectedTaskIds) {
        while (this.arrivedTaskIds.size() < expectedTaskIds.size() || this.waitingOnPermits > 0L) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("waitForRequiredPermits: InterruptedException occurred");
            }
            this.progressable.progress();
            if (!LOG.isInfoEnabled()) continue;
            if (this.arrivedTaskIds.size() < expectedTaskIds.size()) {
                String logSuffix = "";
                if (expectedTaskIds.size() - this.arrivedTaskIds.size() <= 10) {
                    Sets.SetView difference = Sets.difference(expectedTaskIds, this.arrivedTaskIds);
                    logSuffix = ", task ids: " + difference;
                }
                this.logger.info("waitForRequiredPermits: Waiting for " + (expectedTaskIds.size() - this.arrivedTaskIds.size()) + " more tasks to send their aggregator data" + logSuffix);
                continue;
            }
            this.logger.info("waitForRequiredPermits: Waiting for " + this.waitingOnPermits + " more aggregator requests");
        }
        this.arrivedTaskIds.clear();
        this.waitingOnPermits = 0L;
    }

    public synchronized void requirePermits(long permits, int taskId) {
        this.arrivedTaskIds.add(taskId);
        this.waitingOnPermits += permits;
        this.notifyAll();
    }

    public synchronized void releaseOnePermit() {
        this.releasePermits(1L);
    }

    public synchronized void releasePermits(long permits) {
        this.waitingOnPermits -= permits;
        this.notifyAll();
    }
}

