/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.utils.ConfigurationUtils;
import org.jodah.typetools.TypeResolver;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static String getPackagePath(Object object) {
        return ReflectionUtils.getPackagePath(object.getClass());
    }

    public static String getPackagePath(Class klass) {
        return klass.getPackage().getName().replaceAll("\\.", "/");
    }

    public static <T> Class<?>[] getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        return TypeResolver.resolveArguments(childClass, baseClass);
    }

    public static <T> T newInstance(Class<T> theClass) {
        try {
            return theClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("newInstance: Couldn't instantiate " + theClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("newInstance: Illegal access " + theClass.getName(), e);
        }
    }

    public static <T> T newInstance(Class<T> theClass, ImmutableClassesGiraphConfiguration configuration) {
        T result;
        try {
            result = theClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("newInstance: Couldn't instantiate " + theClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("newInstance: Illegal access " + theClass.getName(), e);
        }
        ConfigurationUtils.configureIfPossible(result, configuration);
        return result;
    }
}

