/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.master.MasterObserver;
import org.apache.giraph.utils.JMap;
import org.apache.giraph.worker.WorkerObserver;
import org.apache.log4j.Logger;

public class ReactiveJMapHistoDumper
extends DefaultImmutableClassesGiraphConfigurable
implements MasterObserver,
WorkerObserver {
    private static final Logger LOG = Logger.getLogger(ReactiveJMapHistoDumper.class);
    private static final int MB = 0x100000;
    private int sleepMillis;
    private int linesToPrint;
    private int minFreeMemory;
    private Thread thread;
    private volatile boolean stop = false;

    @Override
    public void preLoad() {
        this.startSupervisorThread();
    }

    @Override
    public void postSave() {
        this.joinSupervisorThread();
    }

    @Override
    public void preApplication() {
    }

    @Override
    public void postApplication() {
    }

    private void joinSupervisorThread() {
        this.stop = true;
        try {
            this.thread.join(this.sleepMillis + 5000);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Failed to join jmap thread");
        }
    }

    public void startSupervisorThread() {
        this.stop = false;
        final Runtime runtime = Runtime.getRuntime();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!ReactiveJMapHistoDumper.this.stop) {
                        long potentialMemory = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
                        if (potentialMemory / 0x100000L < (long)ReactiveJMapHistoDumper.this.minFreeMemory) {
                            JMap.heapHistogramDump(ReactiveJMapHistoDumper.this.linesToPrint);
                        }
                        Thread.sleep(ReactiveJMapHistoDumper.this.sleepMillis);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"JMap histogram sleep interrupted", (Throwable)e);
                }
            }
        });
        this.thread.setName("ReactiveJMapHistoDumperSupervisorThread");
        this.thread.start();
    }

    @Override
    public void preSuperstep(long superstep) {
    }

    @Override
    public void postSuperstep(long superstep) {
    }

    @Override
    public void applicationFailed(Exception e) {
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration configuration) {
        this.sleepMillis = GiraphConstants.JMAP_SLEEP_MILLIS.get(configuration);
        this.linesToPrint = GiraphConstants.JMAP_PRINT_LINES.get(configuration);
        this.minFreeMemory = GiraphConstants.MIN_FREE_MBS_ON_HEAP.get(configuration);
    }
}

