/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.giraph.utils.CallableFactory;
import org.apache.giraph.utils.LogStacktraceCallable;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class ProgressableUtils {
    private static final Logger LOG = Logger.getLogger(ProgressableUtils.class);
    private static final int DEFUALT_MSEC_PERIOD = 60000;

    private ProgressableUtils() {
    }

    public static void awaitExecutorTermination(ExecutorService executor, Progressable progressable, int msecsPeriod) {
        ProgressableUtils.waitForever(new ExecutorServiceWaitable(executor), progressable, msecsPeriod);
    }

    public static void awaitExecutorTermination(ExecutorService executor, Progressable progressable) {
        ProgressableUtils.waitForever(new ExecutorServiceWaitable(executor), progressable);
    }

    public static void awaitTerminationFuture(EventExecutorGroup group, Progressable progressable) {
        ProgressableUtils.waitForever(new FutureWaitable(group.terminationFuture()), progressable);
    }

    public static <T> T getFutureResult(Future<T> future, Progressable progressable) {
        return ProgressableUtils.waitForever(new FutureWaitable<T>(future), progressable);
    }

    public static void awaitChannelGroupFuture(ChannelGroupFuture future, Progressable progressable) {
        ProgressableUtils.waitForever(new ChannelGroupFutureWaitable(future), progressable);
    }

    public static void awaitChannelFuture(ChannelFuture future, Progressable progressable) {
        ProgressableUtils.waitForever(new ChannelFutureWaitable(future), progressable);
    }

    private static <T> T waitForever(Waitable<T> waitable, Progressable progressable) {
        return ProgressableUtils.waitForever(waitable, progressable, 60000);
    }

    private static <T> T waitForever(Waitable<T> waitable, Progressable progressable, int msecsPeriod) {
        do {
            ProgressableUtils.waitFor(waitable, progressable, msecsPeriod, msecsPeriod);
        } while (!waitable.isFinished());
        try {
            return waitable.getResult();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("waitForever: ExecutionException occurred while waiting for " + waitable, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("waitForever: InterruptedException occurred while waiting for " + waitable, e);
        }
    }

    private static <T> T waitFor(Waitable<T> waitable, Progressable progressable, int msecs, int msecsPeriod) {
        long timeoutTimeMsecs = System.currentTimeMillis() + (long)msecs;
        while (true) {
            progressable.progress();
            int currentWaitMsecs = Math.min(msecs, msecsPeriod);
            try {
                waitable.waitFor(currentWaitMsecs);
                if (waitable.isFinished()) {
                    return waitable.getResult();
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("waitFor: InterruptedException occurred while waiting for " + waitable, e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("waitFor: ExecutionException occurred while waiting for " + waitable, e);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("waitFor: Waiting for " + waitable));
            }
            if (System.currentTimeMillis() >= timeoutTimeMsecs) {
                return waitable.getTimeoutResult();
            }
            msecs = Math.max(0, msecs - currentWaitMsecs);
        }
    }

    public static <R> List<R> getResultsWithNCallables(CallableFactory<R> callableFactory, int numThreads, String threadNameFormat, Progressable progressable) {
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build());
        ArrayList futures = Lists.newArrayListWithCapacity((int)numThreads);
        for (int i = 0; i < numThreads; ++i) {
            Callable<R> callable = callableFactory.newCallable(i);
            Future future = executorService.submit(new LogStacktraceCallable<R>(callable));
            futures.add(future);
        }
        executorService.shutdown();
        ArrayList futureResults = Lists.newArrayListWithCapacity((int)numThreads);
        for (Future future : futures) {
            Object result = ProgressableUtils.getFutureResult(future, progressable);
            futureResults.add(result);
        }
        return futureResults;
    }

    private static class ChannelFutureWaitable
    extends WaitableWithoutResult {
        private final ChannelFuture future;

        public ChannelFutureWaitable(ChannelFuture future) {
            this.future = future;
        }

        @Override
        public void waitFor(int msecs) throws InterruptedException {
            this.future.await((long)msecs, TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean isFinished() {
            return this.future.isDone();
        }
    }

    private static class ChannelGroupFutureWaitable
    extends WaitableWithoutResult {
        private final ChannelGroupFuture future;

        public ChannelGroupFutureWaitable(ChannelGroupFuture future) {
            this.future = future;
        }

        @Override
        public void waitFor(int msecs) throws InterruptedException {
            this.future.await((long)msecs, TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean isFinished() {
            return this.future.isDone();
        }
    }

    private static class ExecutorServiceWaitable
    extends WaitableWithoutResult {
        private final ExecutorService executorService;

        public ExecutorServiceWaitable(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public void waitFor(int msecs) throws InterruptedException {
            this.executorService.awaitTermination(msecs, TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean isFinished() {
            return this.executorService.isTerminated();
        }
    }

    private static class FutureWaitable<T>
    implements Waitable<T> {
        private final Future<T> future;

        public FutureWaitable(Future<T> future) {
            this.future = future;
        }

        @Override
        public void waitFor(int msecs) throws InterruptedException, ExecutionException {
            block2: {
                try {
                    this.future.get(msecs, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (!LOG.isInfoEnabled()) break block2;
                    LOG.info((Object)("waitFor: Future result not ready yet " + this.future));
                }
            }
        }

        @Override
        public boolean isFinished() {
            return this.future.isDone();
        }

        @Override
        public T getResult() throws ExecutionException, InterruptedException {
            return this.future.get();
        }

        @Override
        public T getTimeoutResult() {
            return null;
        }
    }

    private static abstract class WaitableWithoutResult
    implements Waitable<Void> {
        private WaitableWithoutResult() {
        }

        @Override
        public Void getResult() throws ExecutionException, InterruptedException {
            return null;
        }

        @Override
        public Void getTimeoutResult() {
            return null;
        }
    }

    private static interface Waitable<T> {
        public void waitFor(int var1) throws InterruptedException, ExecutionException;

        public boolean isFinished();

        public T getResult() throws ExecutionException, InterruptedException;

        public T getTimeoutResult();
    }
}

