/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.collect.Lists;
import java.util.List;

public class PairList<U, V> {
    protected List<U> firstList;
    protected List<V> secondList;

    public void initialize() {
        this.firstList = Lists.newArrayList();
        this.secondList = Lists.newArrayList();
    }

    public void initialize(int size) {
        this.firstList = Lists.newArrayListWithCapacity((int)size);
        this.secondList = Lists.newArrayListWithCapacity((int)size);
    }

    public void add(U first, V second) {
        this.firstList.add(first);
        this.secondList.add(second);
    }

    public int getSize() {
        return this.firstList.size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    public class Iterator {
        private int position = -1;

        public boolean hasNext() {
            return this.position < PairList.this.getSize() - 1;
        }

        public void next() {
            ++this.position;
        }

        public U getCurrentFirst() {
            return PairList.this.firstList.get(this.position);
        }

        public V getCurrentSecond() {
            return PairList.this.secondList.get(this.position);
        }
    }
}

