/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataInput;
import java.io.IOException;
import org.apache.giraph.utils.ByteArrayOneMessageToManyIds;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class OneMessageToManyIdsIterator<I extends WritableComparable, M extends Writable>
implements VertexIdMessageIterator<I, M> {
    private final ByteArrayOneMessageToManyIds<I, M> vertexIdMessages;
    private final ExtendedDataInput extendedDataInput;
    private I vertexId;
    private M msg;
    private int idsToRead = 0;
    private int msgSize = 0;
    private boolean newMessage;

    public OneMessageToManyIdsIterator(ByteArrayOneMessageToManyIds<I, M> vertexIdMessages) {
        this.vertexIdMessages = vertexIdMessages;
        this.extendedDataInput = vertexIdMessages.getConf().createExtendedDataInput(vertexIdMessages.extendedDataOutput);
    }

    @Override
    public I getCurrentVertexId() {
        return this.vertexId;
    }

    @Override
    public M getCurrentMessage() {
        return this.getCurrentData();
    }

    @Override
    public M getCurrentData() {
        return this.msg;
    }

    @Override
    public M releaseCurrentData() {
        M releasedData = this.msg;
        this.msg = null;
        return releasedData;
    }

    @Override
    public I releaseCurrentVertexId() {
        I releasedVertexId = this.vertexId;
        this.vertexId = null;
        return releasedVertexId;
    }

    @Override
    public boolean hasNext() {
        return this.extendedDataInput.available() > 0;
    }

    private void initialize() {
        if (this.vertexId == null) {
            this.vertexId = this.vertexIdMessages.getConf().createVertexId();
        }
        if (this.msg == null) {
            this.msg = this.vertexIdMessages.createData();
        }
    }

    @Override
    public void next() {
        this.initialize();
        try {
            if (this.idsToRead == 0) {
                this.newMessage = true;
                int initial = this.extendedDataInput.getPos();
                this.msg.readFields((DataInput)this.extendedDataInput);
                this.msgSize = this.extendedDataInput.getPos() - initial;
                this.idsToRead = this.extendedDataInput.readInt();
            } else {
                this.newMessage = false;
            }
            this.vertexId.readFields((DataInput)this.extendedDataInput);
            --this.idsToRead;
        }
        catch (IOException e) {
            throw new IllegalStateException("next: IOException", e);
        }
    }

    @Override
    public int getCurrentMessageSize() {
        return this.getCurrentDataSize();
    }

    @Override
    public int getCurrentDataSize() {
        return this.msgSize;
    }

    @Override
    public boolean isNewMessage() {
        return this.newMessage;
    }
}

