/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.yammer.metrics.util.PercentGauge;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.GiraphMetricsRegistry;

public class MemoryUtils {
    private MemoryUtils() {
    }

    private static double megaBytes(long bytes) {
        return (double)bytes / 1024.0 / 1024.0;
    }

    public static double totalMemoryMB() {
        return MemoryUtils.megaBytes(Runtime.getRuntime().totalMemory());
    }

    public static double maxMemoryMB() {
        return MemoryUtils.megaBytes(Runtime.getRuntime().maxMemory());
    }

    public static double freeMemoryMB() {
        return MemoryUtils.megaBytes(Runtime.getRuntime().freeMemory());
    }

    public static void initMetrics() {
        GiraphMetricsRegistry metrics = GiraphMetrics.get().perJobOptional();
        metrics.getGauge("memory-free-pct", new PercentGauge(){

            protected double getNumerator() {
                return MemoryUtils.freeMemoryMB();
            }

            protected double getDenominator() {
                return MemoryUtils.totalMemoryMB();
            }
        });
    }

    public static String getRuntimeMemoryStats() {
        return String.format("Memory (free/total/max) = %.2fM / %.2fM / %.2fM", MemoryUtils.freeMemoryMB(), MemoryUtils.totalMemoryMB(), MemoryUtils.maxMemoryMB());
    }
}

