/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import org.apache.giraph.aggregators.TextAppendAggregator;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.worker.WorkerAggregatorUsage;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class MasterLoggingAggregator {
    public static final String USE_MASTER_LOGGING_AGGREGATOR = "giraph.useMasterLoggingAggregator";
    public static final boolean USE_MASTER_LOGGING_AGGREGATOR_DEFAULT = false;
    public static final String MASTER_LOGGING_AGGREGATOR_NAME = "masterLoggingAggregator";
    private static final Logger LOG = Logger.getLogger(MasterLoggingAggregator.class);

    private MasterLoggingAggregator() {
    }

    public static boolean useMasterLoggingAggregator(Configuration conf) {
        return conf.getBoolean(USE_MASTER_LOGGING_AGGREGATOR, false);
    }

    public static void setUseMasterLoggingAggregator(boolean useMasterLoggingAggregator, Configuration conf) {
        conf.setBoolean(USE_MASTER_LOGGING_AGGREGATOR, useMasterLoggingAggregator);
    }

    public static void aggregate(String message, WorkerAggregatorUsage workerAggregatorUsage, Configuration conf) {
        if (MasterLoggingAggregator.useMasterLoggingAggregator(conf)) {
            workerAggregatorUsage.aggregate(MASTER_LOGGING_AGGREGATOR_NAME, new Text(message));
        }
    }

    public static void registerAggregator(MasterAggregatorUsage masterAggregatorUsage, Configuration conf) {
        if (MasterLoggingAggregator.useMasterLoggingAggregator(conf)) {
            try {
                masterAggregatorUsage.registerAggregator(MASTER_LOGGING_AGGREGATOR_NAME, TextAppendAggregator.class);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("registerAggregator: InstantiationException occurred");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("registerAggregator: IllegalAccessException occurred");
            }
        }
    }

    public static void logAggregatedValue(MasterAggregatorUsage masterAggregatorUsage, Configuration conf) {
        if (MasterLoggingAggregator.useMasterLoggingAggregator(conf) && LOG.isInfoEnabled()) {
            LOG.info((Object)("logAggregatedValue: \n" + masterAggregatorUsage.getAggregatedValue(MASTER_LOGGING_AGGREGATOR_NAME)));
        }
    }
}

