/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.master.MasterObserver;
import org.apache.giraph.utils.JMap;
import org.apache.giraph.worker.WorkerObserver;
import org.apache.log4j.Logger;

public class JMapHistoDumper
implements MasterObserver,
WorkerObserver {
    private static final Logger LOG = Logger.getLogger(JMapHistoDumper.class);
    private int sleepMillis;
    private int linesToPrint;
    private boolean liveObjectsOnly;
    private Thread thread;
    private boolean stop = false;

    @Override
    public void preLoad() {
        this.startJMapThread();
    }

    @Override
    public void postSave() {
        this.joinJMapThread();
    }

    @Override
    public void preApplication() {
    }

    @Override
    public void postApplication() {
    }

    private void joinJMapThread() {
        this.stop = true;
        try {
            this.thread.join(this.sleepMillis + 5000);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Failed to join jmap thread");
        }
    }

    public void startJMapThread() {
        this.stop = false;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JMapHistoDumper.this.stop) {
                    JMap.heapHistogramDump(JMapHistoDumper.this.linesToPrint, JMapHistoDumper.this.liveObjectsOnly);
                    try {
                        Thread.sleep(JMapHistoDumper.this.sleepMillis);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"JMap histogram sleep interrupted", (Throwable)e);
                    }
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void preSuperstep(long superstep) {
    }

    @Override
    public void postSuperstep(long superstep) {
    }

    @Override
    public void applicationFailed(Exception e) {
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration configuration) {
        this.sleepMillis = GiraphConstants.JMAP_SLEEP_MILLIS.get(configuration);
        this.linesToPrint = GiraphConstants.JMAP_PRINT_LINES.get(configuration);
        this.liveObjectsOnly = GiraphConstants.JMAP_LIVE_ONLY.get(configuration);
    }

    public ImmutableClassesGiraphConfiguration getConf() {
        return null;
    }
}

