/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.Date;

public class JMap {
    public static final String CMD = "jmap ";
    public static final String ARGS = " -histo ";
    private static String LIVE_HISTO_OPTION = " -histo:live ";

    protected JMap() {
    }

    public static int getProcessId() {
        String processId = ManagementFactory.getRuntimeMXBean().getName();
        if (processId.contains("@")) {
            processId = processId.substring(0, processId.indexOf("@"));
        }
        return Integer.parseInt(processId);
    }

    public static void heapHistogramDump(int numLines, boolean liveObjectsOnly) {
        JMap.heapHistogramDump(numLines, liveObjectsOnly, System.err);
    }

    public static void heapHistogramDump(int numLines) {
        JMap.heapHistogramDump(numLines, System.err);
    }

    public static void heapHistogramDump(int numLines, PrintStream printStream) {
        JMap.heapHistogramDump(numLines, false, printStream);
    }

    private static void heapHistogramDump(int numLines, boolean liveObjectsOnly, PrintStream printStream) {
        try {
            String args = liveObjectsOnly ? LIVE_HISTO_OPTION : ARGS;
            Process p = Runtime.getRuntime().exec(CMD + args + JMap.getProcessId());
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));
            printStream.println("JMap " + (liveObjectsOnly ? "histo:live" : "histo") + " dump at " + new Date());
            String line = in.readLine();
            for (int i = 0; i < numLines && line != null; ++i) {
                printStream.println("--\t" + line);
                line = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

