/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.io.formats.GiraphFileInputFormat;
import org.apache.giraph.io.formats.InMemoryVertexOutputFormat;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.utils.FileUtils;
import org.apache.giraph.utils.InMemoryVertexInputFormat;
import org.apache.giraph.utils.TestGraph;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class InternalVertexRunner {
    public static final int LOCAL_ZOOKEEPER_PORT_FROM = 22182;
    public static final int LOCAL_ZOOKEEPER_PORT_TO = 65535;
    private static final Logger LOG = Logger.getLogger(InternalVertexRunner.class);

    private InternalVertexRunner() {
    }

    public static Iterable<String> run(GiraphConfiguration conf, String[] vertexInputData) throws Exception {
        return InternalVertexRunner.run(conf, vertexInputData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runZooKeeperAndJob(QuorumPeerConfig quorumPeerConfig, GiraphJob giraphJob) {
        final InternalZooKeeper zookeeper = new InternalZooKeeper();
        final ServerConfig zkConfig = new ServerConfig();
        zkConfig.readFrom(quorumPeerConfig);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    zookeeper.runFromConfig(zkConfig);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            boolean bl = giraphJob.run(true);
            return bl;
        }
        catch (IOException | ClassNotFoundException | InterruptedException e) {
            LOG.error((Object)"runZooKeeperAndJob: Got exception on running", (Throwable)e);
        }
        finally {
            zookeeper.end();
            executorService.shutdown();
            try {
                executorService.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"runZooKeeperAndJob: Interrupted on waiting", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<String> run(GiraphConfiguration conf, String[] vertexInputData, String[] edgeInputData) throws Exception {
        File tmpDir = FileUtils.createTestDir(conf.getComputationName());
        try {
            Iterable<String> iterable = InternalVertexRunner.run(conf, vertexInputData, edgeInputData, null, tmpDir);
            return iterable;
        }
        finally {
            FileUtils.delete(tmpDir);
        }
    }

    public static Iterable<String> run(GiraphConfiguration conf, String[] vertexInputData, String[] edgeInputData, String checkpointsDir, File tmpDir) throws Exception {
        File vertexInputFile = null;
        File edgeInputFile = null;
        if (conf.hasVertexInputFormat()) {
            vertexInputFile = FileUtils.createTempFile(tmpDir, "vertices.txt");
        }
        if (conf.hasEdgeInputFormat()) {
            edgeInputFile = FileUtils.createTempFile(tmpDir, "edges.txt");
        }
        File outputDir = FileUtils.createTempDir(tmpDir, "output");
        File zkDir = FileUtils.createTempDir(tmpDir, "_bspZooKeeper");
        File zkMgrDir = FileUtils.createTempDir(tmpDir, "_defaultZkManagerDir");
        if (conf.hasVertexInputFormat()) {
            FileUtils.writeLines(vertexInputFile, vertexInputData);
        }
        if (conf.hasEdgeInputFormat()) {
            FileUtils.writeLines(edgeInputFile, edgeInputData);
        }
        int localZookeeperPort = InternalVertexRunner.findAvailablePort();
        conf.setWorkerConfiguration(1, 1, 100.0f);
        GiraphConstants.SPLIT_MASTER_WORKER.set(conf, false);
        GiraphConstants.LOCAL_TEST_MODE.set(conf, true);
        conf.setZookeeperList("localhost:" + String.valueOf(localZookeeperPort));
        conf.set("giraph.zkDir", zkDir.toString());
        GiraphConstants.ZOOKEEPER_MANAGER_DIRECTORY.set(conf, zkMgrDir.toString());
        if (checkpointsDir == null) {
            checkpointsDir = FileUtils.createTempDir(tmpDir, "_checkpoints").toString();
        }
        GiraphConstants.CHECKPOINT_DIRECTORY.set(conf, checkpointsDir);
        GiraphJob job = new GiraphJob(conf, conf.getComputationName());
        Job internalJob = job.getInternalJob();
        if (conf.hasVertexInputFormat()) {
            GiraphFileInputFormat.setVertexInputPath(internalJob.getConfiguration(), new Path(vertexInputFile.toString()));
        }
        if (conf.hasEdgeInputFormat()) {
            GiraphFileInputFormat.setEdgeInputPath(internalJob.getConfiguration(), new Path(edgeInputFile.toString()));
        }
        FileOutputFormat.setOutputPath((Job)job.getInternalJob(), (Path)new Path(outputDir.toString()));
        Properties zkProperties = InternalVertexRunner.configLocalZooKeeper(zkDir, localZookeeperPort);
        QuorumPeerConfig qpConfig = new QuorumPeerConfig();
        qpConfig.parseProperties(zkProperties);
        boolean success = InternalVertexRunner.runZooKeeperAndJob(qpConfig, job);
        if (!success) {
            return null;
        }
        File outFile = new File(outputDir, "part-m-00000");
        if (conf.hasVertexOutputFormat() && outFile.canRead()) {
            return Files.readLines((File)outFile, (Charset)Charsets.UTF_8);
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends WritableComparable, V extends Writable, E extends Writable> void run(GiraphConfiguration conf, TestGraph<I, V, E> graph) throws Exception {
        File tmpDir = FileUtils.createTestDir(conf.getComputationName());
        try {
            InternalVertexRunner.run(conf, graph, tmpDir, null);
        }
        finally {
            FileUtils.delete(tmpDir);
        }
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> void run(GiraphConfiguration conf, TestGraph<I, V, E> graph, File tmpDir, String checkpointsDir) throws Exception {
        File zkDir = FileUtils.createTempDir(tmpDir, "_bspZooKeeper");
        File zkMgrDir = FileUtils.createTempDir(tmpDir, "_defaultZkManagerDir");
        if (checkpointsDir == null) {
            checkpointsDir = FileUtils.createTempDir(tmpDir, "_checkpoints").toString();
        }
        conf.setVertexInputFormatClass(InMemoryVertexInputFormat.class);
        GiraphJob job = new GiraphJob(conf, conf.getComputationName());
        InMemoryVertexInputFormat.setGraph(graph);
        int localZookeeperPort = InternalVertexRunner.findAvailablePort();
        conf.setWorkerConfiguration(1, 1, 100.0f);
        GiraphConstants.SPLIT_MASTER_WORKER.set(conf, false);
        GiraphConstants.LOCAL_TEST_MODE.set(conf, true);
        GiraphConstants.ZOOKEEPER_LIST.set(conf, "localhost:" + String.valueOf(localZookeeperPort));
        conf.set("giraph.zkDir", zkDir.toString());
        GiraphConstants.ZOOKEEPER_MANAGER_DIRECTORY.set(conf, zkMgrDir.toString());
        GiraphConstants.CHECKPOINT_DIRECTORY.set(conf, checkpointsDir);
        Properties zkProperties = InternalVertexRunner.configLocalZooKeeper(zkDir, localZookeeperPort);
        QuorumPeerConfig qpConfig = new QuorumPeerConfig();
        qpConfig.parseProperties(zkProperties);
        InternalVertexRunner.runZooKeeperAndJob(qpConfig, job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends WritableComparable, V extends Writable, E extends Writable> TestGraph<I, V, E> runWithInMemoryOutput(GiraphConfiguration conf, TestGraph<I, V, E> graph) throws Exception {
        File tmpDir = FileUtils.createTestDir(conf.getComputationName());
        try {
            TestGraph<I, V, E> testGraph = InternalVertexRunner.runWithInMemoryOutput(conf, graph, tmpDir, null);
            return testGraph;
        }
        finally {
            FileUtils.delete(tmpDir);
        }
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> TestGraph<I, V, E> runWithInMemoryOutput(GiraphConfiguration conf, TestGraph<I, V, E> graph, File tmpDir, String checkpointsDir) throws Exception {
        conf.setVertexOutputFormatClass(InMemoryVertexOutputFormat.class);
        InMemoryVertexOutputFormat.initializeOutputGraph(conf);
        InternalVertexRunner.run(conf, graph, tmpDir, checkpointsDir);
        return InMemoryVertexOutputFormat.getOutputGraph();
    }

    private static Properties configLocalZooKeeper(File zkDir, int zookeeperPort) {
        Properties zkProperties = new Properties();
        zkProperties.setProperty("tickTime", "2000");
        zkProperties.setProperty("dataDir", zkDir.getAbsolutePath());
        zkProperties.setProperty("clientPort", String.valueOf(zookeeperPort));
        zkProperties.setProperty("maxClientCnxns", "10000");
        zkProperties.setProperty("minSessionTimeout", "10000");
        zkProperties.setProperty("maxSessionTimeout", "100000");
        zkProperties.setProperty("initLimit", "10");
        zkProperties.setProperty("syncLimit", "5");
        zkProperties.setProperty("snapCount", "50000");
        return zkProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findAvailablePort() {
        for (int port = 22182; port < 65535; ++port) {
            ServerSocket ss = null;
            try {
                ss = new ServerSocket(port);
                ss.setReuseAddress(true);
                int n = port;
                return n;
            }
            catch (IOException e) {
                LOG.info((Object)("findAvailablePort: port " + port + " is in use."));
                continue;
            }
            finally {
                if (ss != null && !ss.isClosed()) {
                    try {
                        ss.close();
                    }
                    catch (IOException e) {
                        LOG.info((Object)"findAvailablePort: can't close test socket", (Throwable)e);
                    }
                }
            }
        }
        throw new RuntimeException("No port found in the range [ 22182, 65535)");
    }

    private static class InternalZooKeeper
    extends ZooKeeperServerMain {
        private InternalZooKeeper() {
        }

        void end() {
            this.shutdown();
        }
    }
}

