/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.util.BitSet;

public class IncreasingBitSet {
    public static final int MIN_BITS_TO_SHIFT = 65536;
    private BitSet bitSet = new BitSet();
    private long lastBaseKey = 0L;

    public synchronized boolean add(long key) {
        long remainder = key - this.lastBaseKey;
        this.checkLegalKey(remainder);
        if (remainder < 0L) {
            return false;
        }
        if (this.bitSet.get((int)remainder)) {
            return false;
        }
        this.bitSet.set((int)remainder);
        int nextClearBit = this.bitSet.nextClearBit(0);
        if (nextClearBit >= 65536) {
            this.bitSet = this.bitSet.get(nextClearBit, Math.max(nextClearBit, this.bitSet.length()));
            this.lastBaseKey += (long)nextClearBit;
        }
        return true;
    }

    public synchronized long cardinality() {
        long size = this.bitSet.cardinality();
        return size + this.lastBaseKey;
    }

    public synchronized int size() {
        return this.bitSet.size();
    }

    public synchronized boolean has(long key) {
        long remainder = key - this.lastBaseKey;
        this.checkLegalKey(remainder);
        if (remainder < 0L) {
            return true;
        }
        return this.bitSet.get((int)remainder);
    }

    public synchronized long getLastBaseKey() {
        return this.lastBaseKey;
    }

    private void checkLegalKey(long remainder) {
        if (remainder > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("checkLegalKey: Impossible that to add key " + (remainder + this.lastBaseKey) + " with base " + this.lastBaseKey + " since the " + "spread is too large (> " + Integer.MAX_VALUE);
        }
    }
}

