/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.utils.TestGraph;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class InMemoryVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    private static TestGraph GRAPH;

    public static void setGraph(TestGraph graph) {
        GRAPH = graph;
    }

    public static TestGraph getGraph() {
        return GRAPH;
    }

    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        ArrayList<InputSplit> inputSplitList = new ArrayList<InputSplit>();
        for (int i = 0; i < minSplitCountHint; ++i) {
            inputSplitList.add(new BspInputSplit(i, minSplitCountHint));
        }
        return inputSplitList;
    }

    @Override
    public VertexReader<I, V, E> createVertexReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        return new InMemoryVertexReader();
    }

    private class InMemoryVertexReader
    extends VertexReader<I, V, E> {
        private Iterator<Vertex<I, V, E>> vertexIterator;
        private Vertex<I, V, E> currentVertex;

        private InMemoryVertexReader() {
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) {
            this.vertexIterator = GRAPH.iterator();
        }

        @Override
        public boolean nextVertex() {
            if (this.vertexIterator.hasNext()) {
                this.currentVertex = this.vertexIterator.next();
                return true;
            }
            return false;
        }

        @Override
        public Vertex<I, V, E> getCurrentVertex() {
            return this.currentVertex;
        }

        @Override
        public void close() {
        }

        @Override
        public float getProgress() {
            return 0.0f;
        }
    }
}

