/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class GiraphDepVersions {
    private static final Logger LOG = Logger.getLogger(GiraphDepVersions.class);
    private static final String RESOURCE_NAME = "org/apache/giraph/versions.properties";
    private static final GiraphDepVersions INSTANCE = new GiraphDepVersions();
    private final Properties properties;

    private GiraphDepVersions() {
        URL url = Resources.getResource((String)RESOURCE_NAME);
        this.properties = new Properties();
        try {
            this.properties.load(url.openStream());
        }
        catch (IOException e) {
            LOG.error((Object)"Could not read giraph versions from file org/apache/giraph/versions.properties");
        }
    }

    public static GiraphDepVersions get() {
        return INSTANCE;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String versionOf(String name) {
        return this.properties.getProperty(name);
    }

    public void logVersionsUsed() {
        TreeMap sortedVersions = Maps.newTreeMap();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            sortedVersions.put(entry.getKey().toString(), entry.getValue().toString());
        }
        StringBuilder sb = new StringBuilder(sortedVersions.size() * 20);
        for (Map.Entry entry : sortedVersions.entrySet()) {
            sb.append("  ").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
        }
        LOG.info((Object)("Versions of Giraph dependencies =>\n" + sb));
    }
}

