/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger LOG = Logger.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static File createTestDir(String computationName) throws IOException {
        String systemTmpDir = System.getProperty("java.io.tmpdir");
        long simpleRandomLong = (long)(9.223372036854776E18 * Math.random());
        File testTempDir = new File(systemTmpDir, "giraph-" + computationName + '-' + simpleRandomLong);
        if (!testTempDir.mkdir()) {
            throw new IOException("Could not create " + testTempDir);
        }
        testTempDir.deleteOnExit();
        return testTempDir;
    }

    public static File createTempFile(File parent, String name) throws IOException {
        return FileUtils.createTestTempFileOrDir(parent, name, false);
    }

    public static File createTempDir(File parent, String name) throws IOException {
        File dir = FileUtils.createTestTempFileOrDir(parent, name, true);
        if (!dir.delete()) {
            LOG.error((Object)("createTempDir: Failed to create directory " + dir));
        }
        return dir;
    }

    public static File createTestTempFileOrDir(File parent, String name, boolean dir) throws IOException {
        File f = new File(parent, name);
        f.deleteOnExit();
        if (dir && !f.mkdirs()) {
            throw new IOException("Could not make directory " + f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, String[] lines) throws IOException {
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        try {
            for (String line : lines) {
                writer.write(line);
                ((Writer)writer).write(10);
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)true);
        }
    }

    public static void delete(File dir) {
        if (dir != null) {
            new DeletingVisitor().accept(dir);
        }
    }

    public static void deletePath(Configuration conf, String path) throws IOException {
        FileUtils.deletePath(conf, new Path(path));
    }

    public static void deletePath(Configuration conf, Path path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(path, true);
    }

    private static class DeletingVisitor
    implements FileFilter {
        private DeletingVisitor() {
        }

        @Override
        public boolean accept(File f) {
            if (!f.isFile() && f.listFiles(this) == null) {
                LOG.error((Object)("accept: Failed to list files of " + f));
            }
            if (!f.delete()) {
                LOG.error((Object)("accept: Failed to delete file " + f));
            }
            return false;
        }
    }
}

