/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.giraph.conf.FloatConfOption;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.IntConfOption;
import org.apache.giraph.utils.ExtendedDataOutput;

public class ExtendedByteArrayOutputBuffer {
    public static final IntConfOption CAPACITY_OF_DATAOUT_IN_BUFFER = new IntConfOption("giraph.capacityOfDataOutInBuffer", 0x100000, "Set the capacity of dataoutputs in dataout buffer");
    public static final FloatConfOption FILLING_THRESHOLD_OF_DATAOUT_IN_BUFFER = new FloatConfOption("giraph.fillingThresholdOfDataoutInBuffer", 0.98f, "Set the maximum fraction of dataoutput capacity allowed to fill");
    private final int maxBufSize;
    private final int threshold;
    private final ImmutableClassesGiraphConfiguration<?, ?, ?> config;
    private final Int2ObjectOpenHashMap<ExtendedDataOutput> bytearrayOutputs = new Int2ObjectOpenHashMap();
    private final AtomicInteger mapSize = new AtomicInteger(0);
    private final ThreadLocal<IndexAndDataOut> threadLocal = new ThreadLocal<IndexAndDataOut>(){

        @Override
        protected IndexAndDataOut initialValue() {
            return ExtendedByteArrayOutputBuffer.this.newIndexAndDataOutput();
        }
    };

    public ExtendedByteArrayOutputBuffer(ImmutableClassesGiraphConfiguration<?, ?, ?> config) {
        this.config = config;
        this.maxBufSize = CAPACITY_OF_DATAOUT_IN_BUFFER.get(config);
        this.threshold = (int)(FILLING_THRESHOLD_OF_DATAOUT_IN_BUFFER.get(config) * (float)this.maxBufSize);
    }

    public IndexAndDataOut getIndexAndDataOut() {
        IndexAndDataOut indexAndDataOut = this.threadLocal.get();
        if (indexAndDataOut.dataOutput.getPos() >= this.threshold) {
            indexAndDataOut = this.newIndexAndDataOutput();
            this.threadLocal.set(indexAndDataOut);
        }
        return indexAndDataOut;
    }

    public ExtendedDataOutput getDataOutput(int index) {
        return (ExtendedDataOutput)this.bytearrayOutputs.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexAndDataOut newIndexAndDataOutput() {
        int index = this.mapSize.getAndIncrement();
        ExtendedDataOutput output = this.config.createExtendedDataOutput(this.maxBufSize);
        Int2ObjectOpenHashMap<ExtendedDataOutput> int2ObjectOpenHashMap = this.bytearrayOutputs;
        synchronized (int2ObjectOpenHashMap) {
            this.bytearrayOutputs.put(index, (Object)output);
        }
        return new IndexAndDataOut(index, output);
    }

    public static class IndexAndDataOut {
        private final int index;
        private final ExtendedDataOutput dataOutput;

        public IndexAndDataOut(int index, ExtendedDataOutput dataOutput) {
            this.index = index;
            this.dataOutput = dataOutput;
        }

        public int getIndex() {
            return this.index;
        }

        public ExtendedDataOutput getDataOutput() {
            return this.dataOutput;
        }
    }
}

