/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.giraph.utils.ExtendedDataOutput;

public class ExtendedByteArrayDataOutput
extends ByteArrayOutputStream
implements ExtendedDataOutput {
    private static final int DEFAULT_BYTES = 32;
    private final DataOutput dataOutput;

    public ExtendedByteArrayDataOutput(byte[] buf) {
        this.buf = buf == null ? new byte[32] : buf;
        this.dataOutput = new DataOutputStream(this);
    }

    public ExtendedByteArrayDataOutput(byte[] buf, int pos) {
        this(buf);
        this.count = pos;
    }

    public ExtendedByteArrayDataOutput() {
        this(32);
    }

    public ExtendedByteArrayDataOutput(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
        this.dataOutput = new DataOutputStream(this);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dataOutput.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dataOutput.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dataOutput.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dataOutput.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dataOutput.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dataOutput.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dataOutput.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dataOutput.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dataOutput.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dataOutput.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.dataOutput.writeUTF(s);
    }

    @Override
    public void ensureWritable(int minSize) {
        if (this.count + minSize > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, this.count + minSize));
        }
    }

    @Override
    public void skipBytes(int bytesToSkip) {
        this.ensureWritable(bytesToSkip);
        this.count += bytesToSkip;
    }

    @Override
    public void writeInt(int position, int value) {
        if (position + 4 > this.count) {
            throw new IndexOutOfBoundsException("writeIntOnPosition: Tried to write int to position " + position + " but current length is " + this.count);
        }
        this.buf[position] = (byte)(value >>> 24 & 0xFF);
        this.buf[position + 1] = (byte)(value >>> 16 & 0xFF);
        this.buf[position + 2] = (byte)(value >>> 8 & 0xFF);
        this.buf[position + 3] = (byte)(value >>> 0 & 0xFF);
    }

    @Override
    public byte[] toByteArray(int offset, int length) {
        if (offset + length > this.count) {
            throw new IndexOutOfBoundsException(String.format("Offset: %d + Length: %d exceeds the size of buf : %d", offset, length, this.count));
        }
        return Arrays.copyOfRange(this.buf, offset, length);
    }

    @Override
    public byte[] getByteArray() {
        return this.buf;
    }

    @Override
    public int getPos() {
        return this.count;
    }
}

