/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.utils.EdgeComparator;
import org.apache.giraph.utils.Trimmable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class EdgeIterables {
    private EdgeIterables() {
    }

    public static <I extends WritableComparable, E extends WritableComparable> boolean equals(Iterable<Edge<I, E>> e1, Iterable<Edge<I, E>> e2) {
        Iterator<Edge<I, E>> i1 = e1.iterator();
        Iterator<Edge<I, E>> i2 = e2.iterator();
        while (i1.hasNext()) {
            if (!i2.hasNext()) {
                return false;
            }
            if (EdgeComparator.equal(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public static <I extends WritableComparable, E extends WritableComparable> ArrayList<Edge<I, E>> copy(Iterable<Edge<I, E>> edges) {
        Configuration conf = new Configuration();
        ArrayList<Edge<I, Edge<WritableComparable, Writable>>> edgeList = new ArrayList<Edge<I, Edge<WritableComparable, Writable>>>(Iterables.size(edges));
        for (Edge<I, E> edge : edges) {
            edgeList.add(EdgeFactory.create((WritableComparable)WritableUtils.clone(edge.getTargetVertexId(), (Configuration)conf), WritableUtils.clone(edge.getValue(), (Configuration)conf)));
        }
        return edgeList;
    }

    public static <I extends WritableComparable, E extends WritableComparable> boolean sameEdges(Iterable<Edge<I, E>> e1, Iterable<Edge<I, E>> e2) {
        ArrayList<Edge<I, E>> edgeList1 = EdgeIterables.copy(e1);
        ArrayList<Edge<I, E>> edgeList2 = EdgeIterables.copy(e2);
        EdgeComparator edgeComparator = new EdgeComparator();
        Collections.sort(edgeList1, edgeComparator);
        Collections.sort(edgeList2, edgeComparator);
        return EdgeIterables.equals(edgeList1, edgeList2);
    }

    public static <I extends WritableComparable, E extends Writable> int size(Iterable<Edge<I, E>> edges) {
        if (edges instanceof OutEdges) {
            return ((OutEdges)edges).size();
        }
        return Iterables.size(edges);
    }

    public static <I extends WritableComparable, E extends Writable> void initialize(OutEdges<I, E> edges, Iterable<Edge<I, E>> edgesIterable) {
        if (edgesIterable instanceof OutEdges || edgesIterable instanceof Collection) {
            edges.initialize(EdgeIterables.size(edgesIterable));
        } else {
            edges.initialize();
        }
        for (Edge<I, E> edge : edgesIterable) {
            edges.add(edge);
        }
        if (edges instanceof Trimmable) {
            ((Trimmable)((Object)edges)).trim();
        }
    }
}

