/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.giraph.edge.Edge;
import org.apache.hadoop.io.WritableComparable;

public class EdgeComparator<I extends WritableComparable, E extends WritableComparable>
implements Comparator<Edge<I, E>>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(Edge<I, E> e1, Edge<I, E> e2) {
        return EdgeComparator.compareEdges(e1, e2);
    }

    public static <I extends WritableComparable, E extends WritableComparable> int compareEdges(Edge<I, E> e1, Edge<I, E> e2) {
        return ComparisonChain.start().compare(e1.getTargetVertexId(), e2.getTargetVertexId()).compare((Comparable)e1.getValue(), (Comparable)e2.getValue()).result();
    }

    public static <I extends WritableComparable, E extends WritableComparable> boolean equal(Edge<I, E> e1, Edge<I, E> e2) {
        return EdgeComparator.compareEdges(e1, e2) == 0;
    }
}

