/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteOrder;

public class DynamicChannelBufferOutputStream
implements DataOutput {
    private ByteBuf buffer;

    public DynamicChannelBufferOutputStream(int estimatedLength) {
        this.buffer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)estimatedLength)).order(ByteOrder.LITTLE_ENDIAN);
    }

    public DynamicChannelBufferOutputStream(ByteBuf buffer) {
        this.buffer = buffer;
        buffer.clear();
    }

    public ByteBuf getDynamicChannelBuffer() {
        return this.buffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.writeBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.writeBytes(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.buffer.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.buffer.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.buffer.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.buffer.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.buffer.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.buffer.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.buffer.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.buffer.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.writeByte((int)((byte)s.charAt(i)));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buffer.writeByte(v >>> 8 & 0xFF);
            this.buffer.writeByte(v >>> 0 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        char c;
        int i;
        int strlen = s.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.buffer.writeByte((int)((byte)(utflen >>> 8 & 0xFF)));
        this.buffer.writeByte((int)((byte)(utflen >>> 0 & 0xFF)));
        i = 0;
        for (i = 0; i < strlen && (c = s.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.buffer.writeByte((int)((byte)c));
        }
        while (i < strlen) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.writeByte((int)((byte)c));
            } else if (c > '\u07ff') {
                this.buffer.writeByte((int)((byte)(0xE0 | c >> 12 & 0xF)));
                this.buffer.writeByte((int)((byte)(0x80 | c >> 6 & 0x3F)));
                this.buffer.writeByte((int)((byte)(0x80 | c >> 0 & 0x3F)));
            } else {
                this.buffer.writeByte((int)((byte)(0xC0 | c >> 6 & 0x1F)));
                this.buffer.writeByte((int)((byte)(0x80 | c >> 0 & 0x3F)));
            }
            ++i;
        }
    }
}

