/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class DynamicChannelBufferInputStream
implements DataInput {
    private ByteBuf buffer;

    public DynamicChannelBufferInputStream(ByteBuf buffer) {
        this.buffer = buffer;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.buffer.readBytes(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buffer.readBytes(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.buffer.skipBytes(n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        byte ch = this.buffer.readByte();
        if (ch < 0) {
            throw new IllegalStateException("readBoolean: Got " + ch);
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buffer.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.buffer.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.buffer.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        byte c;
        char[] buf = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            c = this.buffer.readByte();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    byte c2 = this.buffer.readByte();
                    if (c2 == 10 || c2 == -1) break block4;
                    this.buffer.readerIndex(this.buffer.readerIndex() - 1);
                    break block4;
                }
                default: {
                    if (--room < 0) {
                        char[] replacebuf = new char[offset + 128];
                        room = replacebuf.length - offset - 1;
                        System.arraycopy(buf, 0, replacebuf, 0, offset);
                        buf = replacebuf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.buffer.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararrCount = 0;
        this.buffer.readBytes(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }
}

