/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.base.Optional;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DistributedCacheUtils {
    private static final Logger LOG = Logger.getLogger(DistributedCacheUtils.class);

    private DistributedCacheUtils() {
    }

    public static Optional<Path> getLocalCacheFile(Configuration conf, String pathToMatch) {
        Path[] paths;
        String nameToPath = FilenameUtils.getName((String)pathToMatch);
        try {
            paths = DistributedCache.getLocalCacheFiles((Configuration)conf);
        }
        catch (IOException e) {
            return Optional.absent();
        }
        for (Path path : paths) {
            if (!FilenameUtils.getName((String)path.toString()).equals(nameToPath)) continue;
            return Optional.of((Object)path);
        }
        return Optional.absent();
    }

    public static Path copyToHdfs(Path path, Configuration conf) {
        if (path.toString().startsWith("hdfs://")) {
            return path;
        }
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get HDFS FileSystem", e);
        }
        String name = FilenameUtils.getBaseName((String)path.toString()) + "-" + System.nanoTime();
        Path remotePath = new Path("/tmp/giraph", name);
        LOG.info((Object)("copyToHdfsIfNecessary: Copying " + path + " to " + remotePath + " on hdfs " + fs.getUri()));
        try {
            fs.copyFromLocalFile(false, true, path, remotePath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to copy jython script from local path " + path + " to hdfs path " + remotePath + " on hdfs " + fs.getUri(), e);
        }
        return remotePath;
    }

    public static Path copyAndAdd(Path path, Configuration conf) {
        Path remotePath = DistributedCacheUtils.copyToHdfs(path, conf);
        DistributedCache.addCacheFile((URI)remotePath.toUri(), (Configuration)conf);
        return remotePath;
    }
}

