/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.giraph.Algorithm;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConfigurationSettable;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.GiraphTypes;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.TypesHolder;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.Language;
import org.apache.giraph.io.formats.GiraphFileInputFormat;
import org.apache.giraph.job.GiraphConfigurationValidator;
import org.apache.giraph.jython.JythonUtils;
import org.apache.giraph.scripting.DeployType;
import org.apache.giraph.scripting.ScriptLoader;
import org.apache.giraph.utils.AnnotationUtils;
import org.apache.giraph.utils.DistributedCacheUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.ZooKeeper;

public final class ConfigurationUtils {
    private static final Logger LOG = Logger.getLogger(ConfigurationUtils.class);
    private static Options OPTIONS = new Options();

    private ConfigurationUtils() {
    }

    public static void configureIfPossible(Object object, ImmutableClassesGiraphConfiguration configuration) {
        if (configuration != null) {
            configuration.configureIfPossible(object);
        } else if (object instanceof GiraphConfigurationSettable) {
            throw new IllegalArgumentException("Trying to configure configurable object without value, " + object.getClass());
        }
    }

    public static Class<? extends TypesHolder> getTypesHolderClass(Configuration conf) {
        Class<TypesHolder> klass = GiraphConstants.TYPES_HOLDER_CLASS.get(conf);
        if (klass != null) {
            return klass;
        }
        klass = GiraphConstants.COMPUTATION_CLASS.get(conf);
        return klass;
    }

    public static CommandLine parseArgs(GiraphConfiguration giraphConf, String[] args) throws ClassNotFoundException, ParseException, IOException {
        if (args.length == 0) {
            throw new IllegalArgumentException("No arguments were provided (try -h)");
        }
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(OPTIONS, args);
        if (cmd.hasOption("h")) {
            ConfigurationUtils.printHelp();
            return null;
        }
        if (cmd.hasOption("la")) {
            ConfigurationUtils.printSupportedAlgorithms();
            return null;
        }
        ConfigurationUtils.performSanityCheck(cmd);
        String computationClassName = args[0];
        int workers = Integer.parseInt(cmd.getOptionValue('w'));
        ConfigurationUtils.populateGiraphConfiguration(giraphConf, cmd, computationClassName, workers);
        GiraphConfigurationValidator gtv = new GiraphConfigurationValidator(giraphConf);
        gtv.validateConfiguration();
        return cmd;
    }

    public static void addOption(String opt, String longOpt, boolean hasArg, String description) {
        if (OPTIONS.hasOption(opt)) {
            ConfigurationUtils.printHelp();
            throw new IllegalArgumentException("GiraphConfiguration already provides a '" + opt + "' option, please choose another identifier.");
        }
        OPTIONS.addOption(opt, longOpt, hasArg, description);
    }

    private static void performSanityCheck(CommandLine cmd) {
        if (!cmd.hasOption("w")) {
            throw new IllegalArgumentException("Need to choose the number of workers (-w)");
        }
        if (!cmd.hasOption("vif") && !cmd.hasOption("eif")) {
            throw new IllegalArgumentException("Need to set an input format (-vif or -eif)");
        }
    }

    private static void populateGiraphConfiguration(GiraphConfiguration conf, CommandLine cmd, String computationClassName, int workers) throws ClassNotFoundException, IOException {
        conf.setWorkerConfiguration(workers, workers, 100.0f);
        if (cmd.hasOption("typesHolder")) {
            Class<?> typesHolderClass = Class.forName(cmd.getOptionValue("typesHolder"));
            GiraphConstants.TYPES_HOLDER_CLASS.set(conf, typesHolderClass);
        }
        if (cmd.hasOption("c")) {
            conf.setMessageCombinerClass(Class.forName(cmd.getOptionValue("c")));
        }
        if (cmd.hasOption("vc")) {
            conf.setVertexValueCombinerClass(Class.forName(cmd.getOptionValue("vc")));
        }
        if (cmd.hasOption("ve")) {
            conf.setOutEdgesClass(Class.forName(cmd.getOptionValue("ve")));
        }
        if (cmd.hasOption("ive")) {
            conf.setInputOutEdgesClass(Class.forName(cmd.getOptionValue("ive")));
        }
        if (cmd.hasOption("wc")) {
            conf.setWorkerContextClass(Class.forName(cmd.getOptionValue("wc")));
        }
        if (cmd.hasOption("mc")) {
            conf.setMasterComputeClass(Class.forName(cmd.getOptionValue("mc")));
        }
        if (cmd.hasOption("aw")) {
            conf.setAggregatorWriterClass(Class.forName(cmd.getOptionValue("aw")));
        }
        if (cmd.hasOption("vif")) {
            conf.setVertexInputFormatClass(Class.forName(cmd.getOptionValue("vif")));
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"No vertex input format specified. Ensure your InputFormat does not require one.");
        }
        if (cmd.hasOption("eif")) {
            conf.setEdgeInputFormatClass(Class.forName(cmd.getOptionValue("eif")));
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"No edge input format specified. Ensure your InputFormat does not require one.");
        }
        if (cmd.hasOption("vof")) {
            conf.setVertexOutputFormatClass(Class.forName(cmd.getOptionValue("vof")));
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"No vertex output format specified. Ensure your OutputFormat does not require one.");
        }
        if (cmd.hasOption("vof") && cmd.hasOption("vsd")) {
            conf.setVertexOutputFormatSubdir(cmd.getOptionValue("vsd"));
        }
        if (cmd.hasOption("eof")) {
            conf.setEdgeOutputFormatClass(Class.forName(cmd.getOptionValue("eof")));
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"No edge output format specified. Ensure your OutputFormat does not require one.");
        }
        if (cmd.hasOption("eof") && cmd.hasOption("esd")) {
            conf.setEdgeOutputFormatSubdir(cmd.getOptionValue("esd"));
        }
        if (!(!cmd.hasOption("vof") || !cmd.hasOption("eof") || !cmd.hasOption("op") || cmd.hasOption("vsd") && !cmd.hasOption("esd") || conf.hasEdgeOutputFormatSubdir() && conf.hasVertexOutputFormatSubdir())) {
            throw new IllegalArgumentException("If VertexOutputFormat and EdgeOutputFormat are both set, it is mandatory to provide both vertex subdirectory as well as edge subdirectory");
        }
        if (cmd.hasOption("pc")) {
            conf.setPartitionClass(Class.forName(cmd.getOptionValue("pc")));
        }
        if (cmd.hasOption("vvf")) {
            conf.setVertexValueFactoryClass(Class.forName(cmd.getOptionValue("vvf")));
        }
        if (cmd.hasOption("ca")) {
            for (String caOptionValue : cmd.getOptionValues("ca")) {
                for (String paramValue : Splitter.on((char)',').split((CharSequence)caOptionValue)) {
                    String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'=').split((CharSequence)paramValue), String.class);
                    if (parts.length != 2) {
                        throw new IllegalArgumentException("Unable to parse custom  argument: " + paramValue);
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Setting custom argument [" + parts[0] + "] to [" + parts[1] + "] in GiraphConfiguration"));
                    }
                    conf.set(parts[0], parts[1]);
                }
            }
        }
        if (cmd.hasOption("vif")) {
            if (cmd.hasOption("vip")) {
                if (FileSystem.get((Configuration)new Configuration()).listStatus(new Path(cmd.getOptionValue("vip"))) == null) {
                    throw new IllegalArgumentException("Invalid vertex input path (-vip): " + cmd.getOptionValue("vip"));
                }
                GiraphFileInputFormat.addVertexInputPath(conf, new Path(cmd.getOptionValue("vip")));
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)"No input path for vertex data was specified. Ensure your InputFormat does not require one.");
            }
        }
        if (cmd.hasOption("eif")) {
            if (cmd.hasOption("eip")) {
                if (FileSystem.get((Configuration)new Configuration()).listStatus(new Path(cmd.getOptionValue("eip"))) == null) {
                    throw new IllegalArgumentException("Invalid edge input path (-eip): " + cmd.getOptionValue("eip"));
                }
                GiraphFileInputFormat.addEdgeInputPath(conf, new Path(cmd.getOptionValue("eip")));
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)"No input path for edge data was specified. Ensure your InputFormat does not require one.");
            }
        }
        if (cmd.hasOption("yj")) {
            conf.setYarnLibJars(cmd.getOptionValue("yj"));
        }
        if (cmd.hasOption("yh")) {
            conf.setYarnTaskHeapMb(Integer.parseInt(cmd.getOptionValue("yh")));
        }
        ConfigurationUtils.handleComputationClass(conf, cmd, computationClassName);
    }

    private static void handleComputationClass(GiraphConfiguration conf, CommandLine cmd, String computationClassName) throws ClassNotFoundException {
        if (computationClassName.endsWith("py")) {
            ConfigurationUtils.handleJythonComputation(conf, cmd, computationClassName);
        } else {
            conf.setComputationClass(Class.forName(computationClassName));
        }
    }

    private static void handleJythonComputation(GiraphConfiguration conf, CommandLine cmd, String scriptPath) {
        String jythonClass = cmd.getOptionValue("jythonClass");
        if (jythonClass == null) {
            throw new IllegalArgumentException("handleJythonComputation: Need to set Jython Computation class name with --jythonClass");
        }
        String typesHolderClass = cmd.getOptionValue("typesHolder");
        if (typesHolderClass == null) {
            throw new IllegalArgumentException("handleJythonComputation: Need to set TypesHolder class name with --typesHolder");
        }
        Path path = new Path(scriptPath);
        Path remotePath = DistributedCacheUtils.copyAndAdd(path, conf);
        ScriptLoader.setScriptsToLoad((Configuration)conf, remotePath.toString(), DeployType.DISTRIBUTED_CACHE, Language.JYTHON);
        GiraphTypes.readFrom(conf).writeIfUnset(conf);
        JythonUtils.init(conf, jythonClass);
    }

    private static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ConfigurationUtils.class.getName(), OPTIONS, true);
    }

    private static void printSupportedAlgorithms() {
        Logger.getLogger(ZooKeeper.class).setLevel(Level.OFF);
        List<Class<?>> classes = AnnotationUtils.getAnnotatedClasses(Algorithm.class, "org.apache.giraph");
        System.out.print("  Supported algorithms:\n");
        for (Class<?> clazz : classes) {
            if (!Computation.class.isAssignableFrom(clazz)) continue;
            Algorithm algorithm = clazz.getAnnotation(Algorithm.class);
            StringBuilder sb = new StringBuilder();
            sb.append(algorithm.name()).append(" - ").append(clazz.getName()).append("\n");
            if (!algorithm.description().equals("")) {
                sb.append("    ").append(algorithm.description()).append("\n");
            }
            System.out.print(sb.toString());
        }
    }

    static {
        OPTIONS.addOption("h", "help", false, "Help");
        OPTIONS.addOption("la", "listAlgorithms", false, "List supported algorithms");
        OPTIONS.addOption("q", "quiet", false, "Quiet output");
        OPTIONS.addOption("yj", "yarnjars", true, "comma-separated list of JAR filenames to distribute to Giraph tasks and ApplicationMaster. YARN only. Search order: CLASSPATH, HADOOP_HOME, user current dir.");
        OPTIONS.addOption("yh", "yarnheap", true, "Heap size, in MB, for each Giraph task (YARN only.) Defaults to " + GiraphConstants.GIRAPH_YARN_TASK_HEAP_MB + " MB.");
        OPTIONS.addOption("w", "workers", true, "Number of workers");
        OPTIONS.addOption("vif", "vertexInputFormat", true, "Vertex input format");
        OPTIONS.addOption("eif", "edgeInputFormat", true, "Edge input format");
        OPTIONS.addOption("vof", "vertexOutputFormat", true, "Vertex output format");
        OPTIONS.addOption("eof", "edgeOutputFormat", true, "Edge output format");
        OPTIONS.addOption("vip", "vertexInputPath", true, "Vertex input path");
        OPTIONS.addOption("eip", "edgeInputPath", true, "Edge input path");
        OPTIONS.addOption("op", "outputPath", true, "Output path");
        OPTIONS.addOption("vsd", "vertexSubDir", true, "subdirectory to be used for the vertex output");
        OPTIONS.addOption("esd", "edgeSubDir", true, "subdirectory to be used for the edge output");
        OPTIONS.addOption("c", "combiner", true, "MessageCombiner class");
        OPTIONS.addOption("ve", "outEdges", true, "Vertex edges class");
        OPTIONS.addOption("wc", "workerContext", true, "WorkerContext class");
        OPTIONS.addOption("aw", "aggregatorWriter", true, "AggregatorWriter class");
        OPTIONS.addOption("mc", "masterCompute", true, "MasterCompute class");
        OPTIONS.addOption("cf", "cacheFile", true, "Files for distributed cache");
        OPTIONS.addOption("pc", "partitionClass", true, "Partition class");
        OPTIONS.addOption("vvf", "vertexValueFactoryClass", true, "Vertex value factory class");
        OPTIONS.addOption("th", "typesHolder", true, "Class that holds types. Needed only if Computation is not set");
        OPTIONS.addOption("jyc", "jythonClass", true, "Jython class name, used if computation passed in is a python script");
        OPTIONS.addOption("ca", "customArguments", true, "provide custom arguments for the job configuration in the form: -ca <param1>=<value1>,<param2>=<value2> -ca <param3>=<value3> etc. It can appear multiple times, and the last one has effect for the same param.");
    }
}

