/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class CollectionUtils {
    private static final Logger LOG = Logger.getLogger(CollectionUtils.class);

    private CollectionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, C extends Collection<V>> C addConcurrent(K key, C values, ConcurrentMap<K, C> map) {
        Collection currentValues = (Collection)map.get(key);
        if (currentValues == null && (currentValues = (Collection)map.putIfAbsent(key, values)) == null) {
            return values;
        }
        Collection collection = currentValues;
        synchronized (collection) {
            currentValues.addAll(values);
        }
        return (C)currentValues;
    }

    public static <T> boolean isEqual(Iterable<T> first, Iterable<T> second) {
        int firstSize = Iterables.size(first);
        int secondSize = Iterables.size(second);
        boolean[] usedSecondArray = new boolean[secondSize];
        for (T firstValue : first) {
            boolean foundFirstValue = false;
            Iterator<T> secondIterator = second.iterator();
            for (int i = 0; i < usedSecondArray.length; ++i) {
                T secondValue = secondIterator.next();
                if (usedSecondArray[i] || !firstValue.equals(secondValue)) continue;
                usedSecondArray[i] = true;
                foundFirstValue = true;
                break;
            }
            if (foundFirstValue) continue;
            LOG.error((Object)("isEqual: Couldn't find element from first (" + firstValue + ") in second " + second + "(size=" + secondSize + ")"));
            return false;
        }
        Iterator<T> secondIterator = second.iterator();
        for (int i = 0; i < usedSecondArray.length; ++i) {
            T secondValue = secondIterator.next();
            if (usedSecondArray[i]) continue;
            LOG.error((Object)("isEqual: Element " + secondValue + " (index " + i + ") in second " + second + "(size=" + secondSize + ") not found in " + first + " (size=" + firstSize + ")"));
            return false;
        }
        return true;
    }
}

