/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.IOException;
import java.security.InvalidParameterException;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class CheckpointingUtils {
    public static final String CHECKPOINT_METADATA_POSTFIX = ".metadata";
    public static final String CHECKPOINT_VERTICES_POSTFIX = ".vertices";
    public static final String CHECKPOINT_VALID_POSTFIX = ".valid";
    public static final String CHECKPOINT_DATA_POSTFIX = ".data";
    public static final String CHECKPOINT_FINALIZED_POSTFIX = ".finalized";
    private static final Logger LOG = Logger.getLogger(CheckpointingUtils.class);

    private CheckpointingUtils() {
    }

    public static String getCheckpointBasePath(Configuration conf, String jobId) {
        return GiraphConstants.CHECKPOINT_DIRECTORY.getWithDefault(conf, GiraphConstants.CHECKPOINT_DIRECTORY.getDefaultValue() + "/" + jobId);
    }

    public static Path getCheckpointMarkPath(Configuration conf, String jobId) {
        return new Path(CheckpointingUtils.getCheckpointBasePath(conf, jobId), "halt");
    }

    public static long getLastCheckpointedSuperstep(FileSystem fs, String checkpointBasePath) throws IOException {
        FileStatus[] fileStatusArray = fs.listStatus(new Path(checkpointBasePath), (PathFilter)new FinalizedCheckpointPathFilter());
        if (fileStatusArray == null) {
            return -1L;
        }
        long lastCheckpointedSuperstep = Long.MIN_VALUE;
        for (FileStatus file : fileStatusArray) {
            long superstep = CheckpointingUtils.getCheckpoint(file);
            if (superstep <= lastCheckpointedSuperstep) continue;
            lastCheckpointedSuperstep = superstep;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getLastGoodCheckpoint: Found last good checkpoint " + lastCheckpointedSuperstep));
        }
        return lastCheckpointedSuperstep;
    }

    private static long getCheckpoint(FileStatus finalizedPath) {
        if (!finalizedPath.getPath().getName().endsWith(CHECKPOINT_FINALIZED_POSTFIX)) {
            throw new InvalidParameterException("getCheckpoint: " + finalizedPath + "Doesn't end in " + CHECKPOINT_FINALIZED_POSTFIX);
        }
        String checkpointString = finalizedPath.getPath().getName().replace(CHECKPOINT_FINALIZED_POSTFIX, "");
        return Long.parseLong(checkpointString);
    }

    private static class FinalizedCheckpointPathFilter
    implements PathFilter {
        private FinalizedCheckpointPathFilter() {
        }

        public boolean accept(Path path) {
            return path.getName().endsWith(CheckpointingUtils.CHECKPOINT_FINALIZED_POSTFIX);
        }
    }
}

