/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataInput;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.giraph.utils.AbstractVertexIdData;
import org.apache.giraph.utils.ByteStructVertexIdDataIterator;
import org.apache.giraph.utils.VertexIdMessageBytesIterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

@NotThreadSafe
public abstract class ByteStructVertexIdMessageBytesIterator<I extends WritableComparable, M extends Writable>
extends ByteStructVertexIdDataIterator<I, M>
implements VertexIdMessageBytesIterator<I, M> {
    protected int messageOffset = -1;
    protected int messageBytes = -1;

    public ByteStructVertexIdMessageBytesIterator(AbstractVertexIdData<I, M> vertexIdData) {
        super(vertexIdData);
    }

    @Override
    public void next() {
        if (this.vertexId == null) {
            this.vertexId = this.vertexIdData.getConf().createVertexId();
        }
        try {
            this.vertexId.readFields((DataInput)this.extendedDataInput);
            this.messageBytes = this.extendedDataInput.readInt();
            this.messageOffset = this.extendedDataInput.getPos();
            if (this.extendedDataInput.skipBytes(this.messageBytes) != this.messageBytes) {
                throw new IllegalStateException("next: Failed to skip " + this.messageBytes);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("next: IOException", e);
        }
    }
}

