/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.VertexIdIterator;
import org.apache.hadoop.io.WritableComparable;

public abstract class ByteStructVertexIdIterator<I extends WritableComparable>
implements VertexIdIterator<I> {
    protected final ExtendedDataInput extendedDataInput;
    protected I vertexId;

    public ByteStructVertexIdIterator(ExtendedDataOutput extendedDataOutput, ImmutableClassesGiraphConfiguration<I, ?, ?> conf) {
        if (extendedDataOutput == null || conf == null) {
            throw new IllegalStateException("Cannot instantiate vertexIdIterator with null arguments");
        }
        this.extendedDataInput = conf.createExtendedDataInput(extendedDataOutput);
    }

    @Override
    public boolean hasNext() {
        return !this.extendedDataInput.endOfInput();
    }

    @Override
    public I getCurrentVertexId() {
        return this.vertexId;
    }

    @Override
    public I releaseCurrentVertexId() {
        I releasedVertexId = this.vertexId;
        this.vertexId = null;
        return releasedVertexId;
    }
}

