/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataInput;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.giraph.utils.AbstractVertexIdData;
import org.apache.giraph.utils.ByteStructVertexIdIterator;
import org.apache.giraph.utils.VertexIdDataIterator;
import org.apache.hadoop.io.WritableComparable;

@NotThreadSafe
public class ByteStructVertexIdDataIterator<I extends WritableComparable, T>
extends ByteStructVertexIdIterator<I>
implements VertexIdDataIterator<I, T> {
    protected AbstractVertexIdData<I, T> vertexIdData;
    protected int dataSize;
    private T data;

    public ByteStructVertexIdDataIterator(AbstractVertexIdData<I, T> vertexIdData) {
        super(vertexIdData.extendedDataOutput, vertexIdData.getConf());
        this.vertexIdData = vertexIdData;
    }

    @Override
    public void next() {
        if (this.vertexId == null) {
            this.vertexId = this.vertexIdData.getConf().createVertexId();
        }
        if (this.data == null) {
            this.data = this.vertexIdData.createData();
        }
        try {
            this.vertexId.readFields((DataInput)this.extendedDataInput);
            int initial = this.extendedDataInput.getPos();
            this.vertexIdData.readData(this.extendedDataInput, this.data);
            this.dataSize = this.extendedDataInput.getPos() - initial;
        }
        catch (IOException e) {
            throw new IllegalStateException("next: IOException", e);
        }
    }

    @Override
    public int getCurrentDataSize() {
        return this.dataSize;
    }

    @Override
    public T getCurrentData() {
        return this.data;
    }

    @Override
    public T releaseCurrentData() {
        T releasedData = this.data;
        this.data = null;
        return releasedData;
    }
}

