/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.hadoop.io.Writable;

public abstract class ByteStructIterator<T extends Writable>
implements Iterator<T> {
    protected final ExtendedDataInput extendedDataInput;

    public ByteStructIterator(ExtendedDataInput extendedDataInput) {
        this.extendedDataInput = extendedDataInput;
    }

    @Override
    public boolean hasNext() {
        return !this.extendedDataInput.endOfInput();
    }

    @Override
    public T next() {
        T writable = this.createWritable();
        try {
            writable.readFields((DataInput)this.extendedDataInput);
        }
        catch (IOException e) {
            throw new IllegalStateException("next: readFields got IOException", e);
        }
        return writable;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove: Not supported");
    }

    protected abstract T createWritable();
}

