/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.ByteArrayVertexIdData;
import org.apache.giraph.utils.ByteStructVertexIdMessageBytesIterator;
import org.apache.giraph.utils.ByteStructVertexIdMessageIterator;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.VerboseByteStructMessageWrite;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class ByteArrayVertexIdMessages<I extends WritableComparable, M extends Writable>
extends ByteArrayVertexIdData<I, M>
implements VertexIdMessages<I, M> {
    private MessageValueFactory<M> messageValueFactory;
    private boolean useMessageSizeEncoding = false;

    public ByteArrayVertexIdMessages(MessageValueFactory<M> messageValueFactory) {
        this.messageValueFactory = messageValueFactory;
    }

    private void setUseMessageSizeEncoding() {
        this.useMessageSizeEncoding = !this.getConf().useMessageCombiner() ? this.getConf().useMessageSizeEncoding() : false;
    }

    @Override
    public M createData() {
        return (M)this.messageValueFactory.newInstance();
    }

    @Override
    public void writeData(ExtendedDataOutput out, M message) throws IOException {
        message.write((DataOutput)out);
    }

    @Override
    public void readData(ExtendedDataInput in, M message) throws IOException {
        message.readFields((DataInput)in);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setUseMessageSizeEncoding();
    }

    @Override
    public void initialize(int expectedSize) {
        super.initialize(expectedSize);
        this.setUseMessageSizeEncoding();
    }

    @Override
    public ByteStructVertexIdMessageIterator<I, M> getVertexIdMessageIterator() {
        return new ByteStructVertexIdMessageIterator(this);
    }

    @Override
    public ByteStructVertexIdMessageBytesIterator<I, M> getVertexIdMessageBytesIterator() {
        if (!this.useMessageSizeEncoding) {
            return null;
        }
        return new ByteStructVertexIdMessageBytesIterator<I, M>(this){

            @Override
            public void writeCurrentMessageBytes(DataOutput dataOutput) {
                try {
                    dataOutput.write(ByteArrayVertexIdMessages.this.extendedDataOutput.getByteArray(), this.messageOffset, this.messageBytes);
                }
                catch (NegativeArraySizeException e) {
                    VerboseByteStructMessageWrite.handleNegativeArraySize(this.vertexId);
                }
                catch (IOException e) {
                    throw new IllegalStateException("writeCurrentMessageBytes: Got IOException", e);
                }
            }
        };
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.useMessageSizeEncoding);
        super.write(dataOutput);
    }

    @Override
    public void readFields(DataInput dataInput) throws IOException {
        this.useMessageSizeEncoding = dataInput.readBoolean();
        super.readFields(dataInput);
    }
}

