/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.ByteArrayVertexIdData;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.OneMessageToManyIdsIterator;
import org.apache.giraph.utils.VertexIdMessageBytesIterator;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class ByteArrayOneMessageToManyIds<I extends WritableComparable, M extends Writable>
extends ByteArrayVertexIdData<I, M>
implements VertexIdMessages<I, M> {
    private MessageValueFactory<M> messageValueFactory;

    public ByteArrayOneMessageToManyIds(MessageValueFactory<M> messageValueFactory) {
        this.messageValueFactory = messageValueFactory;
    }

    @Override
    public M createData() {
        return (M)this.messageValueFactory.newInstance();
    }

    @Override
    public void writeData(ExtendedDataOutput out, M message) throws IOException {
        message.write((DataOutput)out);
    }

    @Override
    public void readData(ExtendedDataInput in, M message) throws IOException {
        message.readFields((DataInput)in);
    }

    public void add(byte[] ids, int idPos, int count, M msg) {
        try {
            msg.write((DataOutput)this.extendedDataOutput);
            this.extendedDataOutput.writeInt(count);
            this.extendedDataOutput.write(ids, 0, idPos);
        }
        catch (IOException e) {
            throw new IllegalStateException("add: IOException", e);
        }
    }

    @Override
    public void add(I vertexId, M data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(byte[] serializedId, int idPos, M data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertexIdMessageBytesIterator<I, M> getVertexIdMessageBytesIterator() {
        return null;
    }

    @Override
    public VertexIdMessageIterator<I, M> getVertexIdMessageIterator() {
        return new OneMessageToManyIdsIterator(this);
    }
}

