/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class ArrayWritable<T extends Writable>
implements Writable {
    private Class<T> valueClass;
    private T[] values;

    public ArrayWritable() {
    }

    public ArrayWritable(Class<T> valueClass, T[] values) {
        Preconditions.checkNotNull(valueClass, (Object)"valueClass cannot be null in ArrayWritable");
        this.valueClass = valueClass;
        this.values = values;
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public void set(T[] values) {
        this.values = values;
    }

    public T[] get() {
        return this.values;
    }

    public void readFields(DataInput in) throws IOException {
        this.valueClass = WritableUtils.readClass(in);
        this.values = (Writable[])Array.newInstance(this.valueClass, in.readInt());
        for (int i = 0; i < this.values.length; ++i) {
            Writable value = WritableFactories.newInstance(this.valueClass);
            value.readFields(in);
            this.values[i] = value;
        }
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull(this.valueClass, (Object)"valueClass cannot be null in ArrayWritable");
        WritableUtils.writeClass(this.valueClass, out);
        out.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].write(out);
        }
    }
}

