/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T extends Annotation> List<Class<?>> getAnnotatedClasses(Class<T> annotation, String packageName) {
        ArrayList ret = new ArrayList();
        Iterator<Class<?>> it = AnnotationUtils.getClassesIterator(packageName);
        while (it.hasNext()) {
            Class<?> clazz = it.next();
            if (clazz.getAnnotation(annotation) == null) continue;
            ret.add(clazz);
        }
        return ret;
    }

    public static Iterator<Class<?>> getClassesIterator(String packageName) {
        if (AnnotationUtils.isExecutedFromJar()) {
            try {
                return new JarClassesIterator(packageName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new GeneralClassesIterator(packageName);
    }

    private static boolean isExecutedFromJar() {
        return AnnotationUtils.class.getResource("AnnotationUtils.class").getProtocol().equals("jar");
    }

    private static String getCurrentJar() {
        return AnnotationUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error loading class " + className, e);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Error loading class " + className, e);
        }
    }

    static /* synthetic */ String access$000() {
        return AnnotationUtils.getCurrentJar();
    }

    private static class GeneralClassesIterator
    implements Iterator<Class<?>> {
        private final int stringPosition;
        private final Iterator<File> iterator;

        public GeneralClassesIterator(String packageName) {
            String mainPath = AnnotationUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            String subPath = packageName.replace(".", File.separator);
            File directory = new File(mainPath + subPath);
            this.stringPosition = directory.getPath().length() - packageName.length();
            ArrayList<File> files = new ArrayList<File>();
            this.addAllClassFiles(directory, files);
            this.iterator = files.iterator();
        }

        private void addAllClassFiles(File directory, List<File> files) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    this.addAllClassFiles(file, files);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                files.add(file);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Class<?> next() {
            String className = this.iterator.next().getPath().substring(this.stringPosition).replace(".class", "").replace(File.separator, ".");
            return AnnotationUtils.loadClass(className);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove from classes iterator");
        }
    }

    private static class JarClassesIterator
    implements Iterator<Class<?>> {
        private final JarInputStream jarIn = new JarInputStream(new FileInputStream(new File(AnnotationUtils.access$000())));
        private boolean entryLoaded = false;
        private JarEntry currentEntry = null;
        private final String path;

        public JarClassesIterator(String packageName) throws IOException {
            this.path = packageName.replace(".", File.separator);
        }

        @Override
        public boolean hasNext() {
            this.loadNextEntry();
            return this.currentEntry != null;
        }

        @Override
        public Class<?> next() {
            this.loadNextEntry();
            if (this.currentEntry == null) {
                throw new NoSuchElementException();
            }
            this.entryLoaded = false;
            String className = this.currentEntry.getName().replace(".class", "").replace(File.separator, ".");
            return AnnotationUtils.loadClass(className);
        }

        private void loadNextEntry() {
            while (!this.entryLoaded) {
                try {
                    this.currentEntry = this.jarIn.getNextJarEntry();
                    if (this.currentEntry == null || this.currentEntry.getName().endsWith(".class") && this.currentEntry.getName().startsWith(this.path)) {
                        this.entryLoaded = true;
                        continue;
                    }
                    this.currentEntry = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.currentEntry == null) {
                try {
                    this.jarIn.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove from classes iterator");
        }
    }
}

